/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.panel;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.client.render.panel.PanelRenderer;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderers;
import malte0811.controlengineering.gui.misc.DataProviderScreen;
import malte0811.controlengineering.network.panellayout.Add;
import malte0811.controlengineering.network.panellayout.Delete;
import malte0811.controlengineering.network.panellayout.PanelPacket;
import malte0811.controlengineering.network.panellayout.PanelSubPacket;
import malte0811.controlengineering.network.panellayout.Replace;
import malte0811.controlengineering.util.ScreenUtils;
import malte0811.controlengineering.util.math.TransformUtil;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;

public class PanelLayout
extends AbstractWidget {
    private static final double PANEL_GRID = 0.5;
    private final List<PlacedComponent> components;
    private PlacingComponent placing;

    public PanelLayout(int x, int y, int size, List<PlacedComponent> components) {
        super(x, y, size, size, TextComponent.f_131282_);
        this.components = components;
    }

    public void setPlacingComponent(PanelComponentType<?, ?> placing) {
        this.placing = new PlacingComponent((PanelComponentInstance)placing.newInstance(), Vec2d.ZERO);
    }

    public void m_6303_(@Nonnull PoseStack transform, int mouseX, int mouseY, float partialTicks) {
        TextureAtlasSprite texture = (TextureAtlasSprite)PanelRenderer.PANEL_TEXTURE.get();
        ScreenUtils.bindForShader(texture);
        transform.m_85836_();
        transform.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        PanelLayout.m_93200_((PoseStack)transform, (int)0, (int)0, (int)0, (int)this.f_93618_, (int)this.f_93619_, (TextureAtlasSprite)texture);
        transform.m_85841_((float)this.getPixelSize(), (float)this.getPixelSize(), 1.0f);
        transform.m_85837_(0.0, 0.0, 2.0);
        transform.m_85845_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
        TransformUtil.shear(transform, 0.1f, 0.1f);
        transform.m_85841_(1.0f, -1.0f, 1.0f);
        MixedModel model = ComponentRenderers.renderAll(this.components, transform, new RenderType[0]);
        if (this.placing != null) {
            Vec2d placingPos = this.placing.getPlacingPos(this, mouseX, mouseY);
            transform.m_85836_();
            transform.m_85837_(placingPos.x(), 0.0, placingPos.y());
            ComponentRenderers.render(model, this.placing.component(), transform);
            transform.m_85849_();
        }
        MultiBufferSource.BufferSource impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        model.renderTo((MultiBufferSource)impl, new PoseStack(), LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        impl.m_109911_();
        transform.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double mouseXPanel = this.getPanelPos(mouseX, this.f_93620_);
        double mouseYPanel = this.getPanelPos(mouseY, this.f_93621_);
        int hovered = PlacedComponent.getIndexAt((Level)Minecraft.m_91087_().f_91073_, this.components, mouseXPanel, mouseYPanel);
        if (button == 0) {
            if (this.placing == null) {
                if (hovered >= 0) {
                    PlacedComponent pickedComponent = this.components.get(hovered);
                    Vec2d offset = pickedComponent.getPosMin().subtract(mouseXPanel - 0.25, mouseYPanel - 0.25);
                    this.placing = new PlacingComponent(pickedComponent.getComponent(), offset);
                    this.delete(mouseX, mouseY);
                    return true;
                }
                return false;
            }
            Vec2d placingPos = this.placing.getPlacingPos(this, (int)mouseX, (int)mouseY);
            PlacedComponent newComponent = new PlacedComponent(this.placing.component(), placingPos);
            if (this.processAndSend(new Add(newComponent))) {
                this.placing = null;
                return true;
            }
        } else if (button == 1 && hovered >= 0) {
            PlacedComponent hoveredComp = this.components.get(hovered);
            this.configure(hoveredComp.getPosMin(), hoveredComp.getComponent());
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261) {
            return this.delete(ScreenUtils.getMousePosition());
        }
        return false;
    }

    private boolean delete(Vec2d mouse) {
        return this.delete(mouse.x(), mouse.y());
    }

    private boolean delete(double mouseX, double mouseY) {
        return this.processAndSend(new Delete(new Vec2d(this.getPanelPos(mouseX, this.f_93620_), this.getPanelPos(mouseY, this.f_93621_))));
    }

    private <T> void configure(Vec2d pos, PanelComponentInstance<T, ?> instance) {
        DataProviderScreen<Object> screen = DataProviderScreen.makeFor(TextComponent.f_131282_, instance.getConfig(), ((PanelComponentType)instance.getType()).getConfigCodec(), config -> this.processAndSend(new Replace(new PlacedComponent(((PanelComponentType)instance.getType()).newInstanceFromCfg(config), pos))));
        if (screen != null) {
            Minecraft.m_91087_().m_91152_(screen);
        }
    }

    private double getPanelPos(double mouse, int base) {
        return (mouse - (double)base) / this.getPixelSize();
    }

    private double getGriddedPanelPos(double mouse, int base) {
        return Math.floor(this.getPanelPos(mouse, base) / 0.5) * 0.5;
    }

    private double getPixelSize() {
        return (double)this.f_93619_ / 16.0;
    }

    private boolean processAndSend(PanelSubPacket packet) {
        if (packet.process((Level)Minecraft.m_91087_().f_91073_, this.components)) {
            ControlEngineering.NETWORK.sendToServer((Object)new PanelPacket(packet));
            return true;
        }
        return false;
    }

    public void m_142291_(@Nonnull NarrationElementOutput pNarrationElementOutput) {
    }

    private record PlacingComponent(PanelComponentInstance<?, ?> component, Vec2d offsetFromMouse) {
        public Vec2d getPlacingPos(PanelLayout relative, double mouseX, double mouseY) {
            double pixel = relative.getPixelSize();
            return new Vec2d(relative.getGriddedPanelPos(mouseX + this.offsetFromMouse.x() * pixel, relative.f_93620_), relative.getGriddedPanelPos(mouseY + this.offsetFromMouse.y() * pixel, relative.f_93621_));
        }
    }
}

