/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.remapper;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blockentity.bus.RSRemapperBlockEntity;
import malte0811.controlengineering.gui.CEContainerMenu;
import malte0811.controlengineering.gui.ContainerScreenManager;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.remapper.FullSync;
import malte0811.controlengineering.network.remapper.RSRemapperPacket;
import malte0811.controlengineering.network.remapper.RSRemapperSubPacket;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class RSRemapperMenu
extends CEContainerMenu<RSRemapperSubPacket> {
    private final Consumer<int[]> setColorToGray;
    private final Supplier<int[]> getColorToGray;

    public RSRemapperMenu(MenuType<?> type, int id, RSRemapperBlockEntity bEntity) {
        super(type, id, ContainerScreenManager.isValidFor((BlockEntity)bEntity), () -> ((RSRemapperBlockEntity)bEntity).m_6596_());
        this.getColorToGray = bEntity::getColorToGray;
        this.setColorToGray = bEntity::setColorToGray;
    }

    public RSRemapperMenu(MenuType<?> type, int id) {
        super(type, id);
        MutableObject colorToGray = new MutableObject((Object)new int[16]);
        this.getColorToGray = () -> ((Mutable)colorToGray).getValue();
        this.setColorToGray = arg_0 -> ((Mutable)colorToGray).setValue(arg_0);
    }

    @Override
    protected SimplePacket makePacket(RSRemapperSubPacket subPacket) {
        return new RSRemapperPacket(subPacket);
    }

    @Override
    protected RSRemapperSubPacket getInitialSync() {
        return new FullSync(this.getColorToGray());
    }

    public void setColorToGray(int[] newCToG) {
        this.setColorToGray.accept(newCToG);
    }

    public int[] getColorToGray() {
        int[] original = this.getColorToGray.get();
        return Arrays.copyOf(original, original.length);
    }

    public void processAndSend(RSRemapperSubPacket packet) {
        RSRemapperPacket fullPacket = new RSRemapperPacket(packet);
        fullPacket.updateConnections(this);
        ControlEngineering.NETWORK.sendToServer((Object)fullPacket);
    }
}

