/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.remapper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.gui.SubTexture;
import malte0811.controlengineering.gui.remapper.RSRemapperMenu;
import malte0811.controlengineering.network.remapper.ClearMapping;
import malte0811.controlengineering.network.remapper.SetMapping;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.ArrayUtils;

public class RSRemapperScreen
extends Screen
implements MenuAccess<RSRemapperMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("controlengineering", "textures/gui/rs_remapper.png");
    private static final int WIDTH = 113;
    private static final int HEIGHT = 154;
    private static final int WRAP_X_COLOR = 19;
    private static final int WRAP_X_GRAY = 90;
    private static final int FIRST_WRAP_Y = 15;
    private static final int COLOR_HEIGHT = 8;
    private static final int WIRE_COLOR = -4824526;
    private static final SubTexture BACKGROUND = new SubTexture(TEXTURE, 0, 0, 113, 154);
    private static final SubTexture WRAPPED_WIRE = new SubTexture(TEXTURE, 0, 154, 3, 158);
    private static final List<Pair<Rect2i, ConnectionPoint>> RELATIVE_REGIONS = (List)Util.m_137469_(new ArrayList(), list -> {
        for (int i = 0; i < 16; ++i) {
            int yMin = 15 + i * 8;
            for (Boolean color : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
                int xMin = color != false ? 19 : 90;
                list.add(Pair.of((Object)new Rect2i(xMin, yMin, WRAPPED_WIRE.getWidth(), WRAPPED_WIRE.getHeight()), (Object)new ConnectionPoint(color, i)));
            }
        }
    });
    private final RSRemapperMenu menu;
    private int leftPos;
    private int topPos;
    @Nullable
    private ConnectionPoint fixedEndOfConnecting;

    public RSRemapperScreen(RSRemapperMenu menu) {
        super(TextComponent.f_131282_);
        this.menu = menu;
    }

    public void m_6305_(@Nonnull PoseStack transform, int mouseX, int mouseY, float partialTick) {
        transform.m_85836_();
        transform.m_85837_((double)this.leftPos, (double)this.topPos, 0.0);
        BACKGROUND.blit(transform, 0, 0);
        this.renderConnections(transform);
        if (this.fixedEndOfConnecting != null) {
            this.renderWireAtMouse(transform, this.fixedEndOfConnecting, mouseX - this.leftPos, mouseY - this.topPos);
        }
        transform.m_85849_();
        super.m_6305_(transform, mouseX, mouseY, partialTick);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 113) / 2;
        this.topPos = (this.f_96544_ - 154) / 2;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.fixedEndOfConnecting != null && button == 1) {
            this.fixedEndOfConnecting = null;
            return true;
        }
        if (button == 0) {
            int relativeX = (int)(mouseX - (double)this.leftPos);
            int relativeY = (int)(mouseY - (double)this.topPos);
            for (Pair<Rect2i, ConnectionPoint> region : RELATIVE_REGIONS) {
                if (!((Rect2i)region.getFirst()).m_110087_(relativeX, relativeY)) continue;
                this.onClicked((ConnectionPoint)region.getSecond());
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void onClicked(ConnectionPoint clicked) {
        if (this.fixedEndOfConnecting != null) {
            if (clicked.isAtColor != this.fixedEndOfConnecting.isAtColor) {
                ConnectionPoint oldOtherEnd = this.getOtherEnd(clicked);
                int colorIndex = this.getIndexAtColor(clicked, this.fixedEndOfConnecting);
                int grayIndex = clicked.isAtColor ? this.fixedEndOfConnecting.index : clicked.index;
                this.menu.processAndSend(new SetMapping(colorIndex, grayIndex));
                this.fixedEndOfConnecting = oldOtherEnd;
            } else {
                this.fixedEndOfConnecting = null;
            }
        } else {
            ConnectionPoint otherEnd = this.getOtherEnd(clicked);
            if (otherEnd == null) {
                this.fixedEndOfConnecting = clicked;
            } else {
                this.menu.processAndSend(new ClearMapping(this.getIndexAtColor(clicked, otherEnd)));
                this.fixedEndOfConnecting = otherEnd;
            }
        }
    }

    private void renderConnections(PoseStack transform) {
        int[] colorToGray = this.menu.getColorToGray();
        for (int color = 0; color < colorToGray.length; ++color) {
            int mappedTo = colorToGray[color];
            if (mappedTo == 17) continue;
            ConnectionPoint colorCP = new ConnectionPoint(true, color);
            ConnectionPoint grayCP = new ConnectionPoint(false, mappedTo);
            WRAPPED_WIRE.blit(transform, 19, colorCP.getSpriteY());
            WRAPPED_WIRE.blit(transform, 90, grayCP.getSpriteY());
            this.renderFullyConnectedWire(transform, colorCP.getWireX(), colorCP.getWireY(), grayCP.getWireX(), grayCP.getWireY());
        }
    }

    private void renderFullyConnectedWire(PoseStack transform, float xStart, float yStart, float xEnd, float yEnd) {
        float wireRadius = 1.0f;
        float deltaX = xEnd - xStart;
        float deltaY = yEnd - yStart;
        float cosAlpha = (float)((double)deltaX / Math.sqrt(deltaY * deltaY + deltaX * deltaX));
        float halfWireHeight = Math.abs(1.0f / cosAlpha);
        this.renderWire(transform, xStart, yStart + halfWireHeight, xEnd, yEnd + halfWireHeight, xEnd, yEnd - halfWireHeight, xStart, yStart - halfWireHeight);
    }

    private void renderWireAtMouse(PoseStack transform, ConnectionPoint fixed, int mouseX, int mouseY) {
        float fixedY = fixed.getWireY();
        float fixedX = fixed.getWireX();
        Vec2 radius = new Vec2(fixedY - (float)mouseY, (float)mouseX - fixedX).m_165902_();
        this.renderWire(transform, fixedX + radius.f_82470_, fixedY + radius.f_82471_, (float)mouseX + radius.f_82470_, (float)mouseY + radius.f_82471_, (float)mouseX - radius.f_82470_, (float)mouseY - radius.f_82471_, fixedX - radius.f_82470_, fixedY - radius.f_82471_);
    }

    private void renderWire(PoseStack transform, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = transform.m_85850_().m_85861_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, x1, y1, 0.0f).m_193479_(-4824526).m_5752_();
        bufferbuilder.m_85982_(matrix, x2, y2, 0.0f).m_193479_(-4824526).m_5752_();
        bufferbuilder.m_85982_(matrix, x3, y3, 0.0f).m_193479_(-4824526).m_5752_();
        bufferbuilder.m_85982_(matrix, x4, y4, 0.0f).m_193479_(-4824526).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    @Nonnull
    public RSRemapperMenu getMenu() {
        return this.menu;
    }

    @Nullable
    private ConnectionPoint getOtherEnd(ConnectionPoint first) {
        int invalid;
        int otherIndex;
        int[] mapping = this.menu.getColorToGray();
        if (first.isAtColor) {
            otherIndex = mapping[first.index];
            invalid = 17;
        } else {
            otherIndex = ArrayUtils.indexOf((int[])mapping, (int)first.index);
            invalid = -1;
        }
        if (otherIndex != invalid) {
            return new ConnectionPoint(!first.isAtColor, otherIndex);
        }
        return null;
    }

    private int getIndexAtColor(ConnectionPoint first, ConnectionPoint second) {
        return first.isAtColor ? first.index : second.index;
    }

    private record ConnectionPoint(boolean isAtColor, int index) {
        float getWireY() {
            return (float)this.getSpriteY() + (float)WRAPPED_WIRE.getHeight() / 2.0f;
        }

        float getWireX() {
            if (this.isAtColor) {
                return 19 + WRAPPED_WIRE.getWidth();
            }
            return 90.0f;
        }

        int getSpriteY() {
            return 15 + this.index * 8;
        }
    }
}

