/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.tape;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import java.util.HashSet;
import java.util.Set;
import malte0811.controlengineering.blockentity.tape.KeypunchBlockEntity;
import malte0811.controlengineering.blockentity.tape.KeypunchState;
import malte0811.controlengineering.gui.CEContainerMenu;
import malte0811.controlengineering.gui.ContainerScreenManager;
import malte0811.controlengineering.gui.misc.LambdaDataSlot;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.keypunch.FullSync;
import malte0811.controlengineering.network.keypunch.KeypunchPacket;
import malte0811.controlengineering.network.keypunch.KeypunchSubPacket;
import malte0811.controlengineering.network.keypunch.TypeChar;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;

public class KeypunchMenu
extends CEContainerMenu<KeypunchSubPacket> {
    private final KeypunchState state;
    private final ByteConsumer printNonLoopback;
    private final DataSlot isLoopback;
    private final Set<KeypunchMenu> openMenus;

    public KeypunchMenu(MenuType<?> type, int id, KeypunchBlockEntity keypunch) {
        super(type, id, ContainerScreenManager.isValidFor(keypunch), () -> ((KeypunchBlockEntity)keypunch).m_6596_());
        this.state = keypunch.getState();
        this.printNonLoopback = keypunch::queueForRemotePrint;
        this.isLoopback = this.m_38895_(LambdaDataSlot.serverSide(() -> keypunch.isLoopback() ? 1 : 0));
        this.openMenus = keypunch.getOpenContainers();
    }

    public KeypunchMenu(MenuType<?> type, int id) {
        super(type, id);
        this.state = new KeypunchState(() -> {});
        this.printNonLoopback = $ -> {};
        this.isLoopback = this.m_38895_(DataSlot.m_39401_());
        this.openMenus = new HashSet<KeypunchMenu>();
    }

    @Override
    protected SimplePacket makePacket(KeypunchSubPacket data) {
        return new KeypunchPacket(data);
    }

    @Override
    protected KeypunchSubPacket getInitialSync() {
        return new FullSync(this.state.getAvailable(), this.state.getData().toByteArray());
    }

    public KeypunchState getState() {
        return this.state;
    }

    public boolean isLoopback() {
        return this.isLoopback.m_6501_() != 0;
    }

    public void onTypedOnServer(byte data) {
        this.sendToListeningPlayers(new TypeChar(data));
    }

    public void resyncFullTape() {
        this.sendToListeningPlayers(this.getInitialSync());
    }

    @Override
    protected void onFirstOpened() {
        super.onFirstOpened();
        this.openMenus.add(this);
    }

    @Override
    protected void onLastClosed() {
        super.onLastClosed();
        this.openMenus.remove((Object)this);
    }

    public ByteConsumer getPrintNonLoopback() {
        return this.printNonLoopback;
    }
}

