/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.tape;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blockentity.tape.KeypunchState;
import malte0811.controlengineering.gui.SubTexture;
import malte0811.controlengineering.gui.tape.KeypunchMenu;
import malte0811.controlengineering.gui.tape.TapeRender;
import malte0811.controlengineering.gui.widget.Keyboard;
import malte0811.controlengineering.gui.widget.KeyboardButton;
import malte0811.controlengineering.network.keypunch.Backspace;
import malte0811.controlengineering.network.keypunch.KeypunchPacket;
import malte0811.controlengineering.network.keypunch.KeypunchSubPacket;
import malte0811.controlengineering.network.keypunch.TypeChar;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class KeypunchScreen
extends Screen
implements MenuAccess<KeypunchMenu> {
    private static final int KEY_SIZE = 20;
    private static final int NUM_VISIBLE_CHARS = 23;
    private static final int MAX_CHARS_PER_SECOND = 8;
    private static final int MIN_CHAR_DELAY = 125;
    public static final ResourceLocation TEXTURE = new ResourceLocation("controlengineering", "textures/gui/keypunch.png");
    private static final SubTexture MAIN_SCREEN = new SubTexture(TEXTURE, 0, 0, 256, 79);
    private static final SubTexture SMALL_KEY = new SubTexture(TEXTURE, 0, 128, 16, 144);
    private static final SubTexture CAPS_KEY = new SubTexture(TEXTURE, 0, 144, 32, 160);
    private static final SubTexture SPACE_KEY = new SubTexture(TEXTURE, 0, 160, 128, 176);
    private final KeypunchMenu container;
    private final KeypunchState state;
    private final TapeRender tapeRender;
    private boolean isCapsLock;

    public KeypunchScreen(KeypunchMenu container, Component title) {
        super(title);
        this.container = container;
        this.state = container.getState();
        this.tapeRender = new TapeRender(50, 27, () -> this.f_96547_, this.getBytes());
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int row = 0; row < Keyboard.ROWS.length; ++row) {
            int y = this.getRowY(row);
            char[] rowChars = Keyboard.ROWS[row].chars.toCharArray();
            for (int col = 0; col < rowChars.length; ++col) {
                int x = this.getKeyX(Keyboard.ROWS[row].relativeStartOffset + (double)col);
                this.m_142416_((GuiEventListener)new KeyboardButton(x, y, c -> this.type((byte)c), SMALL_KEY, rowChars[col], () -> this.isCapsLock));
            }
        }
        this.m_142416_((GuiEventListener)CAPS_KEY.createButton(this.getKeyX(-0.25), this.getRowY(2), btn -> {
            this.isCapsLock = !this.isCapsLock;
        }));
        this.m_142416_((GuiEventListener)SPACE_KEY.createButton((this.f_96543_ - SPACE_KEY.getWidth()) / 2, this.getRowY(4), btn -> this.type((byte)32)));
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.getXStart(), (double)this.getYStart(), 0.0);
        MAIN_SCREEN.blit(matrixStack, 0, 0);
        this.tapeRender.render(matrixStack);
        this.f_96547_.m_92883_(matrixStack, Integer.toString(this.state.getAvailable()), 210.0f, 35.0f, -1);
        matrixStack.m_85849_();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    private int getRowY(int row) {
        return this.getYStart() + 85 + row * 20;
    }

    private int getKeyX(double relative) {
        return (int)((double)this.getXStart() + relative * 20.0);
    }

    private int getXStart() {
        return (this.f_96543_ - MAIN_SCREEN.getWidth()) / 2;
    }

    private int getYStart() {
        return (this.f_96544_ - MAIN_SCREEN.getHeight() - 100) / 2;
    }

    private byte[] getBytes() {
        byte[] shown = new byte[23];
        int numToCopy = Math.min(23, this.state.getData().size());
        int firstArrayIndex = Math.max(0, 23 - numToCopy);
        int firstListIndex = Math.max(0, this.state.getData().size() - numToCopy);
        for (int i = 0; i < numToCopy; ++i) {
            shown[i + firstArrayIndex] = this.state.getData().getByte(i + firstListIndex);
        }
        return shown;
    }

    private void type(byte newChar) {
        this.processAndSend(new TypeChar(newChar));
    }

    public void updateData() {
        this.tapeRender.setData(this.getBytes());
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (codePoint <= '\u007f') {
            this.type((byte)codePoint);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            return this.processAndSend(new Backspace());
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Nonnull
    public KeypunchMenu getMenu() {
        return this.container;
    }

    public KeypunchState getState() {
        return this.state;
    }

    private boolean processAndSend(KeypunchSubPacket packet) {
        if (!this.container.isLoopback() || packet.process(this.state)) {
            this.updateData();
            ControlEngineering.NETWORK.sendToServer((Object)new KeypunchPacket(packet));
            return true;
        }
        return false;
    }
}

