/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.tape;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.RedstoneTapeUtils;
import malte0811.controlengineering.util.ScreenUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.RedStoneWireBlock;

public class TapeRender {
    private static final int TAPE_COLOR = -3235422;
    private static final int HOLE_WIDTH = 3;
    private static final int HOLE_HEIGHT = 2;
    public static final int CHAR_DISTANCE = 6;
    public static final int TAPE_WIDTH = 29;
    private static final int[] HOLE_OFFSETS = new int[]{0, 3, 6, 11, 14, 17, 20, 23};
    private final int xStart;
    private final int yStart;
    private final Supplier<Font> font;
    private byte[] data;

    public TapeRender(int xStart, int yStart, Supplier<Font> font, byte[] data) {
        this.xStart = xStart;
        this.yStart = yStart;
        this.font = font;
        this.data = data;
    }

    public void render(PoseStack matrixStack) {
        byte[] shownBytes = this.data;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.xStart, 0.0, 0.0);
        this.renderHoles(matrixStack, shownBytes);
        matrixStack.m_85837_(-1.5, 0.0, 0.0);
        this.renderChars(matrixStack, shownBytes);
        this.renderRSAndColor(matrixStack, shownBytes);
        matrixStack.m_85849_();
    }

    public void setData(byte[] data) {
        Preconditions.checkState((data.length == this.data.length ? 1 : 0) != 0);
        this.data = data;
    }

    private void renderHoles(PoseStack matrixStack, byte[] shownBytes) {
        this.forEachRow(matrixStack, shownBytes, 6.0f, this.yStart, (transform, currentByte) -> {
            for (int bit = 0; bit < HOLE_OFFSETS.length; ++bit) {
                if (BitUtils.getBit(currentByte.byteValue(), bit)) continue;
                int yPos = HOLE_OFFSETS[bit];
                GuiComponent.m_93172_((PoseStack)transform, (int)0, (int)yPos, (int)3, (int)(yPos + 2), (int)-3235422);
            }
        });
    }

    private void renderChars(PoseStack matrixStack, byte[] shownBytes) {
        double vOffset = this.yStart + 29 + 1;
        int delta = 8;
        this.forEachRow(matrixStack, shownBytes, 8.0f, vOffset, (transform, currentByte) -> {
            char asChar = (char)BitUtils.clearParity(currentByte);
            if (asChar <= ' ' || asChar >= '\u007f') {
                asChar = '.';
            }
            String toPrint = String.valueOf(asChar);
            float width = this.font.get().m_92865_().m_92353_(toPrint);
            float centerOffset = (8.0f - width) / 2.0f;
            int color = -1;
            if (!BitUtils.isCorrectParity(currentByte)) {
                color &= 0xFF0000;
            }
            this.font.get().m_92883_(transform, toPrint, centerOffset, 0.0f, color);
        });
    }

    private void renderRSAndColor(PoseStack matrixStack, byte[] shownBytes) {
        int sideSpace = -2;
        Objects.requireNonNull(this.font.get());
        double vOffset = this.yStart + 29 + 9 - 2;
        float rsSize = 12.0f;
        TextureAtlas texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = texture.m_118316_(new ResourceLocation("block/redstone_dust_dot"));
        ScreenUtils.bindForShader(sprite);
        this.forEachRow(matrixStack, shownBytes, 12.0f, vOffset, (transform, currentByte) -> {
            int strength = RedstoneTapeUtils.getStrength(currentByte);
            int color = RedStoneWireBlock.m_55606_((int)strength);
            TapeRender.blitWithColor(transform, -2, 16, 16, sprite, color);
        });
        TextureAtlasSprite white = QuadBuilder.getWhiteTexture();
        ScreenUtils.bindForShader(white);
        this.forEachRow(matrixStack, shownBytes, 1.0f, vOffset + 6.0 + 2.0, (transform, currentByte) -> {
            DyeColor color = RedstoneTapeUtils.getColor(currentByte);
            TapeRender.blitWithColor(transform, 0, 1, 1, white, color.m_41071_());
        });
    }

    private void forEachRow(PoseStack matrixStack, byte[] shownBytes, float width, double verticalOffset, BiConsumer<PoseStack, Byte> draw) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, verticalOffset, 0.0);
        float factor = 6.0f / width;
        matrixStack.m_85841_(factor, factor, 1.0f);
        for (byte b : shownBytes) {
            draw.accept(matrixStack, b);
            matrixStack.m_85837_((double)width, 0.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    private static void blitWithColor(PoseStack m, int x, int width, int height, TextureAtlasSprite texture, int color) {
        RenderSystem.m_157429_((float)((float)BitUtils.getBits(color, 16, 8) / 255.0f), (float)((float)BitUtils.getBits(color, 8, 8) / 255.0f), (float)((float)BitUtils.getBits(color, 0, 8) / 255.0f), (float)1.0f);
        GuiComponent.m_93200_((PoseStack)m, (int)x, (int)0, (int)0, (int)width, (int)height, (TextureAtlasSprite)texture);
    }
}

