/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.tape;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.gui.tape.TapeRender;
import malte0811.controlengineering.network.CutTapePacket;
import malte0811.controlengineering.util.ScreenUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class ViewTapeScreen
extends Screen {
    public static final ResourceLocation BASE_SCREEN = new ResourceLocation("controlengineering", "textures/gui/read_tape.png");
    private static final int WIDTH = 256;
    private static final int HEIGHT = 128;
    private static final int FIRST_CHAR_X = 48;
    private static final int FIRST_HOLE_Y = 65;
    private static final int TAPE_MIN_Y = 63;
    private static final int NUM_VISIBLE_CHARS = 27;
    private final byte[] fullData;
    private int offset = 0;
    private final TapeRender tapeRender;
    private final boolean canCut;
    private final InteractionHand tapeHand;

    public ViewTapeScreen(String titleIn, byte[] data, InteractionHand tapeHand) {
        super((Component)new TextComponent(titleIn));
        this.fullData = data;
        this.canCut = CutTapePacket.canCut(tapeHand, (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_));
        this.tapeHand = tapeHand;
        this.tapeRender = new TapeRender(48, 65, () -> this.f_96547_, this.getShownBytes());
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 20;
        int leftButtonX = 18 + (this.f_96543_ - 256) / 2;
        int buttonY = 68 + (this.f_96544_ - 128) / 2;
        this.m_142416_((GuiEventListener)new Button(leftButtonX + 1, buttonY, 20, 20, (Component)new TextComponent("<"), btn -> this.incOffset()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - leftButtonX - 20 + 1, buttonY, 20, 20, (Component)new TextComponent(">"), btn -> this.decOffset()));
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int visualCutOffset;
        this.m_7333_(matrixStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE_SCREEN);
        int startX = (this.f_96543_ - 256) / 2;
        int startY = (this.f_96544_ - 128) / 2;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)startX, (double)startY, 0.0);
        this.m_93228_(matrixStack, 0, 0, 0, 0, 256, 128);
        this.tapeRender.render(matrixStack);
        if (this.canCut && (visualCutOffset = this.getVisualFocussedRow(mouseX - startX, mouseY - startY)) >= 0) {
            double xMin = (double)(48 + visualCutOffset * 6) - 1.5;
            int color = -2130771968;
            ScreenUtils.fill(matrixStack, xMin, 63.0, xMin + 6.0, 92.0, -2130771968);
        }
        matrixStack.m_85849_();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private int getVisualFocussedRow(double mouseX, double mouseY) {
        if (mouseY < 63.0 || mouseY > 92.0) {
            return -1;
        }
        int row = (int)Math.round((mouseX - 48.0 - 1.5) / 6.0);
        if (row < 0 || row < -this.offset || row >= 27 || row >= this.fullData.length - this.offset) {
            return -1;
        }
        return row;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            this.incOffset();
        } else {
            this.decOffset();
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int startX = (this.f_96543_ - 256) / 2;
        int startY = (this.f_96544_ - 128) / 2;
        int visualRow = this.getVisualFocussedRow(mouseX - (double)startX, mouseY - (double)startY);
        if (this.canCut && visualRow >= 0) {
            this.m_7379_();
            ControlEngineering.NETWORK.sendToServer((Object)new CutTapePacket(this.tapeHand, visualRow + this.offset));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private byte[] getShownBytes() {
        byte[] result = new byte[27];
        for (int i = 0; i < 27; ++i) {
            int actualIndex = i + this.offset;
            result[i] = actualIndex < this.fullData.length && actualIndex >= 0 ? this.fullData[actualIndex] : (byte)0;
        }
        return result;
    }

    public boolean m_7043_() {
        return false;
    }

    private void incOffset() {
        if (this.offset < Math.max(this.fullData.length - 13, 0)) {
            ++this.offset;
        }
        this.tapeRender.setData(this.getShownBytes());
    }

    private void decOffset() {
        if (this.offset > -13) {
            --this.offset;
        }
        this.tapeRender.setData(this.getShownBytes());
    }
}

