/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.DyeColor;

public class ColorPicker16
extends AbstractWidget {
    public static final int GRID_SIZE = 16;
    public static final int NUM_COLS = 4;
    public static final int SIZE = 64;
    public static final int TITLE_SPACE = 10;
    private DyeColor selected;

    public ColorPicker16(int x, int y, Component title, @Nullable DyeColor initial) {
        super(x, y, 64, 74, title);
        this.selected = initial;
    }

    public void m_6303_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        float offset = (float)(this.f_93618_ - font.m_92852_((FormattedText)this.m_6035_())) / 2.0f;
        font.m_92889_(matrixStack, this.m_6035_(), (float)this.f_93620_ + offset, (float)this.f_93621_, -1);
        DyeColor underCursor = this.getColorUnderCursor(mouseX, mouseY);
        for (DyeColor color : DyeColor.values()) {
            int minX = this.f_93620_ + color.m_41060_() % 4 * 16;
            int minY = this.f_93621_ + color.m_41060_() / 4 * 16 + 10;
            int border = 2;
            if (underCursor == color) {
                int inverse = ColorUtils.inverseColor(color.m_41071_());
                ColorPicker16.m_93172_((PoseStack)matrixStack, (int)minX, (int)minY, (int)(minX + 16), (int)(minY + 16), (int)inverse);
                if (this.selected == color) {
                    border = 1;
                }
            } else if (this.selected == color) {
                border = 0;
            }
            ColorPicker16.m_93172_((PoseStack)matrixStack, (int)(minX + border), (int)(minY + border), (int)(minX + 16 - border), (int)(minY + 16 - border), (int)(0xFF000000 | color.m_41071_()));
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        DyeColor selected = this.getColorUnderCursor(mouseX, mouseY);
        if (selected != null) {
            this.selected = selected == this.selected ? null : selected;
        }
    }

    @Nullable
    public DyeColor getSelected() {
        return this.selected;
    }

    @Nullable
    private DyeColor getColorUnderCursor(double mouseX, double mouseY) {
        int row = (int)((mouseY -= (double)(this.f_93621_ + 10)) / 16.0);
        int col = (int)((mouseX -= (double)this.f_93620_) / 16.0);
        if (row < 0 || row >= 4 || col < 0 || col >= 4) {
            return null;
        }
        int index = row * 4 + col;
        return DyeColor.m_41053_((int)index);
    }

    public void m_142291_(@Nonnull NarrationElementOutput pNarrationElementOutput) {
    }
}

