/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.widget;

import javax.annotation.Nullable;
import malte0811.controlengineering.gui.misc.DataProviderWidget;
import malte0811.controlengineering.gui.misc.IDataProviderWidget;
import malte0811.controlengineering.gui.widget.BasicSlider;
import malte0811.controlengineering.util.math.Fraction;

public class FractionSelector
extends DataProviderWidget<Fraction> {
    private static final int WIDTH = 128;
    private static final int SLIDER_HEIGHT = 20;
    private static final int SLIDER_SPACE = 10;
    private final BasicSlider numerator;
    private final BasicSlider denominator;

    public FractionSelector(@Nullable Fraction initial, int x, int y, int max, String numKey, String denomKey) {
        super(x, y, 128, 50);
        this.numerator = this.addWidget(new BasicSlider(x, y, 128, 20, 1, max, numKey, initial != null ? initial.numerator() : 1));
        this.denominator = this.addWidget(new BasicSlider(x, y + 20 + 10, 128, 20, 1, max, denomKey, initial != null ? initial.denominator() : 1));
    }

    public static IDataProviderWidget.Factory<Fraction, FractionSelector> with(int max, String numKey, String denomKey) {
        return (initial, x, y) -> new FractionSelector((Fraction)initial, x, y, max, numKey, denomKey);
    }

    @Override
    @Nullable
    public Fraction getData() {
        Integer numerator = this.numerator.getData();
        Integer denominator = this.denominator.getData();
        if (numerator != null && denominator != null) {
            return new Fraction(numerator, denominator);
        }
        return null;
    }
}

