/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.widget;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharOpenHashMap;

public class Keyboard {
    private static final Char2CharMap SPECIAL_UPPERCASE = new Char2CharOpenHashMap();
    public static final KeyRow[] ROWS;
    public static final int CAPSLOCK_ROW = 2;
    public static final double CAPSLOCK_START = -0.25;
    public static final int SPACE_ROW = 4;

    private static void addSpecialCap(char lower, char upper) {
        Preconditions.checkArgument((lower <= '\u00ff' ? 1 : 0) != 0);
        Preconditions.checkArgument((upper <= '\u00ff' ? 1 : 0) != 0);
        SPECIAL_UPPERCASE.put(lower, upper);
    }

    public static char upperFor(char in) {
        if (SPECIAL_UPPERCASE.containsKey(in)) {
            return SPECIAL_UPPERCASE.get(in);
        }
        return Character.toUpperCase(in);
    }

    public static char convert(char in, boolean shift) {
        if (shift) {
            return Keyboard.upperFor(in);
        }
        return in;
    }

    static {
        Keyboard.addSpecialCap('1', '!');
        Keyboard.addSpecialCap('2', '@');
        Keyboard.addSpecialCap('3', '#');
        Keyboard.addSpecialCap('4', '$');
        Keyboard.addSpecialCap('5', '%');
        Keyboard.addSpecialCap('6', '^');
        Keyboard.addSpecialCap('7', '&');
        Keyboard.addSpecialCap('8', '*');
        Keyboard.addSpecialCap('9', '(');
        Keyboard.addSpecialCap('0', ')');
        Keyboard.addSpecialCap('-', '_');
        Keyboard.addSpecialCap('=', '+');
        Keyboard.addSpecialCap('[', '{');
        Keyboard.addSpecialCap(']', '}');
        Keyboard.addSpecialCap('\\', '|');
        Keyboard.addSpecialCap(';', ':');
        Keyboard.addSpecialCap('\'', '\"');
        Keyboard.addSpecialCap('.', '<');
        Keyboard.addSpecialCap(',', '>');
        Keyboard.addSpecialCap('/', '?');
        Keyboard.addSpecialCap('`', '~');
        ROWS = new KeyRow[]{new KeyRow(0.0, "`1234567890-="), new KeyRow(1.5, "qwertyuiop[]\\"), new KeyRow(1.75, "asdfghjkl;'"), new KeyRow(2.25, "zxcvbnm,./")};
    }

    public static class KeyRow {
        public final double relativeStartOffset;
        public final String chars;

        private KeyRow(double relativeStartOffset, String chars) {
            this.relativeStartOffset = relativeStartOffset;
            this.chars = chars;
            for (char c : chars.toCharArray()) {
                Preconditions.checkState((Character.isLowerCase(c) || SPECIAL_UPPERCASE.containsKey(c) ? 1 : 0) != 0);
            }
        }
    }
}

