/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blocks.CEBlock;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.items.BusCoilItem;
import malte0811.controlengineering.items.CEBlockItem;
import malte0811.controlengineering.items.ControlPanelItem;
import malte0811.controlengineering.items.EmptyTapeItem;
import malte0811.controlengineering.items.ItemWithKeyID;
import malte0811.controlengineering.items.PCBStackItem;
import malte0811.controlengineering.items.PanelTopItem;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.items.SchematicItem;
import malte0811.controlengineering.logic.clock.ClockGenerator;
import malte0811.controlengineering.logic.clock.ClockTypes;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CEItems {
    public static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"controlengineering");
    public static final RegistryObject<BusCoilItem> BUS_WIRE_COIL = REGISTER.register("bus_wire_coil", BusCoilItem::new);
    public static final RegistryObject<PunchedTapeItem> PUNCHED_TAPE = REGISTER.register("punched_tape", PunchedTapeItem::new);
    public static final RegistryObject<EmptyTapeItem> EMPTY_TAPE = REGISTER.register("empty_tape", EmptyTapeItem::new);
    public static final RegistryObject<PanelTopItem> PANEL_TOP = REGISTER.register("panel_top", PanelTopItem::new);
    public static final RegistryObject<ItemWithKeyID> LOCK = REGISTER.register("lock", ItemWithKeyID::new);
    public static final RegistryObject<ItemWithKeyID> KEY = REGISTER.register("key", ItemWithKeyID::new);
    public static final Map<ResourceLocation, RegistryObject<Item>> CLOCK_GENERATORS;
    public static final RegistryObject<PCBStackItem> PCB_STACK;
    public static final RegistryObject<SchematicItem> SCHEMATIC;
    private static final RegistryObject<CEBlockItem<Direction>> BUS_RELAY;
    private static final RegistryObject<CEBlockItem<Direction>> BUS_INTERFACE;
    private static final RegistryObject<CEBlockItem<Direction>> LINE_ACCESS;
    private static final RegistryObject<CEBlockItem<PanelOrientation>> CONTROL_PANEL;
    private static final RegistryObject<CEBlockItem<Direction>> KEYPUNCH;
    private static final RegistryObject<CEBlockItem<Direction>> SEQUENCER;
    private static final RegistryObject<CEBlockItem<Direction>> PANEL_CNC;
    private static final RegistryObject<CEBlockItem<Direction>> LOGIC_CABINET;
    private static final RegistryObject<CEBlockItem<Direction>> LOGIC_WORKBENCH;
    private static final RegistryObject<CEBlockItem<Direction>> PANEL_DESIGNER;
    private static final RegistryObject<CEBlockItem<Direction>> RS_REMAPPER;

    private static <T> RegistryObject<CEBlockItem<T>> blockItemCE(RegistryObject<? extends CEBlock<T>> block) {
        return CEItems.blockItemCE(block, CEItems.simpleItemProperties());
    }

    private static <T> RegistryObject<CEBlockItem<T>> blockItemCE(RegistryObject<? extends CEBlock<T>> block, Item.Properties properties) {
        return REGISTER.register(block.getId().m_135815_(), () -> new CEBlockItem((CEBlock)((Object)((Object)block.get())), properties));
    }

    public static Item.Properties simpleItemProperties() {
        return new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP);
    }

    static {
        PCB_STACK = REGISTER.register("pcb_stack", PCBStackItem::new);
        SCHEMATIC = REGISTER.register("logic_schematic", SchematicItem::new);
        BUS_RELAY = CEItems.blockItemCE(CEBlocks.BUS_RELAY);
        BUS_INTERFACE = CEItems.blockItemCE(CEBlocks.BUS_INTERFACE);
        LINE_ACCESS = CEItems.blockItemCE(CEBlocks.LINE_ACCESS);
        CONTROL_PANEL = REGISTER.register(CEBlocks.CONTROL_PANEL.getId().m_135815_(), () -> new ControlPanelItem((CEBlock)((Object)((Object)CEBlocks.CONTROL_PANEL.get())), CEItems.simpleItemProperties()));
        KEYPUNCH = CEItems.blockItemCE(CEBlocks.KEYPUNCH);
        SEQUENCER = CEItems.blockItemCE(CEBlocks.SEQUENCER);
        PANEL_CNC = CEItems.blockItemCE(CEBlocks.PANEL_CNC);
        LOGIC_CABINET = CEItems.blockItemCE(CEBlocks.LOGIC_CABINET);
        LOGIC_WORKBENCH = CEItems.blockItemCE(CEBlocks.LOGIC_WORKBENCH);
        PANEL_DESIGNER = CEItems.blockItemCE(CEBlocks.PANEL_DESIGNER);
        RS_REMAPPER = CEItems.blockItemCE(CEBlocks.RS_REMAPPER);
        ImmutableMap.Builder clockSources = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ClockGenerator<?>> entry : ClockTypes.getGenerators().entrySet()) {
            ResourceLocation id = entry.getKey();
            if (!entry.getValue().isActiveClock()) continue;
            clockSources.put((Object)id, (Object)REGISTER.register(id.m_135815_(), () -> new Item(CEItems.simpleItemProperties())));
        }
        CLOCK_GENERATORS = clockSources.build();
    }
}

