/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.controlengineering.blocks.CEBlock;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.client.model.panel.PanelItemRenderer;
import malte0811.controlengineering.controlpanels.PanelData;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.items.CEBlockItem;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemRenderProperties;

public class ControlPanelItem
extends CEBlockItem<PanelOrientation>
implements IConfigurableTool {
    public static final String FRONT_HEIGHT_OPTION = "front_height";
    public static final String BACK_HEIGHT_OPTION = "back_height";

    public ControlPanelItem(CEBlock<PanelOrientation> blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer itemRender = new PanelItemRenderer(is -> ControlPanelItem.this.getPanelData((ItemStack)is));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.itemRender;
            }
        });
    }

    private PanelData getPanelData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        return new PanelData(tag, PanelOrientation.UP_NORTH);
    }

    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        PanelTransform transform = this.getPanelData(stack).getTransform();
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat(FRONT_HEIGHT_OPTION, 60, 20, transform.getFrontHeight()), new IConfigurableTool.ToolConfig.ToolConfigFloat(BACK_HEIGHT_OPTION, 60, 40, transform.getBackHeight())};
    }

    public void applyConfigOption(ItemStack stack, String key, Object valueObj) {
        float backHeight;
        float frontHeight;
        float value = Math.max(((Float)valueObj).floatValue(), 0.001f);
        PanelTransform currentTransform = this.getPanelData(stack).getTransform();
        if (FRONT_HEIGHT_OPTION.equals(key)) {
            frontHeight = value;
            backHeight = currentTransform.getBackHeight();
        } else {
            frontHeight = currentTransform.getFrontHeight();
            backHeight = value;
        }
        PanelTransform newTransform = PanelTransform.withHeights(frontHeight, backHeight, PanelOrientation.UP_NORTH);
        newTransform.addTo(stack.m_41784_());
    }

    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return I18n.m_118938_((String)ControlPanelItem.getKey(config.name), (Object[])new Object[0]);
    }

    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return this.fomatConfigName(stack, config);
    }

    public static String getKey(String option) {
        return "controlengineering.gui.panel_" + option;
    }
}

