/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.util.ItemNBTUtil;
import malte0811.controlengineering.util.TextUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EmptyTapeItem
extends Item {
    private static final String LENGTH_KEY = "length";
    public static final String EMPTY_TAPE_BYTES = "controlengineering.tooltip.empty_tape_bytes";

    public EmptyTapeItem() {
        super(new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP).m_41487_(1));
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)EmptyTapeItem.withLength(16));
            items.add((Object)EmptyTapeItem.withLength(256));
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int length = EmptyTapeItem.getLength(stack);
        TextUtil.addTooltipLine(tooltip, (MutableComponent)new TranslatableComponent(EMPTY_TAPE_BYTES, new Object[]{length}));
    }

    public static ItemStack withLength(int length) {
        ItemStack result = new ItemStack((ItemLike)CEItems.EMPTY_TAPE.get());
        EmptyTapeItem.setLength(result, length);
        return result;
    }

    public static int getLength(ItemStack tape) {
        if (tape.m_41720_() != CEItems.EMPTY_TAPE.get()) {
            return 0;
        }
        return ItemNBTUtil.getTag(tape).map(c -> c.m_128451_(LENGTH_KEY)).orElse(0);
    }

    public static ItemStack setLength(ItemStack tape, int newLength) {
        tape.m_41784_().m_128405_(LENGTH_KEY, newLength);
        return tape;
    }
}

