/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.ISchematicItem;
import malte0811.controlengineering.logic.circuit.BusConnectedCircuit;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicCircuitConverter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class PCBStackItem
extends Item
implements ISchematicItem {
    public static final String FOR_USE_IN_KEY = "controlengineering.gui.useIn";

    public PCBStackItem() {
        super(new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP).m_41487_(1));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> out, @Nonnull TooltipFlag advanced) {
        super.m_7373_(stack, level, out, advanced);
        out.add(PCBStackItem.useIn(CEBlocks.LOGIC_CABINET));
    }

    public static Component useIn(RegistryObject<? extends ItemLike> block) {
        return new TranslatableComponent(FOR_USE_IN_KEY, new Object[]{((ItemLike)block.get()).m_5456_().m_41466_()}).m_130940_(ChatFormatting.GRAY);
    }

    @Nullable
    public static Pair<Schematic, BusConnectedCircuit> getSchematicAndCircuit(ItemStack stack) {
        if (stack.m_41720_() != CEItems.PCB_STACK.get()) {
            return null;
        }
        Schematic schematic = ISchematicItem.getSchematic(stack);
        if (schematic == null) {
            return null;
        }
        Optional<BusConnectedCircuit> circuit = SchematicCircuitConverter.toCircuit(schematic);
        if (!circuit.isPresent()) {
            return null;
        }
        return Pair.of((Object)schematic, (Object)circuit.get());
    }

    public static ItemStack forSchematic(Schematic schematic) {
        if (SchematicCircuitConverter.toCircuit(schematic).isPresent()) {
            return ISchematicItem.create(CEItems.PCB_STACK, schematic);
        }
        return ItemStack.f_41583_;
    }
}

