/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.client.model.panel.PanelItemRenderer;
import malte0811.controlengineering.controlpanels.PanelData;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.items.CEItems;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.IItemRenderProperties;

public class PanelTopItem
extends Item {
    private static final PanelTransform FLAT_PANEL = new PanelTransform(0.0f, 0.0f, PanelOrientation.UP_NORTH);
    private static final String COMPONENTS_KEY = "components";

    public PanelTopItem() {
        super(new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP));
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new PanelItemRenderer(is -> new PanelData(PanelTopItem.getComponentsOn(is), FLAT_PANEL));
            }
        });
    }

    public static boolean isEmptyPanelTop(ItemStack candidate) {
        if (candidate.m_41720_() != CEItems.PANEL_TOP.get()) {
            return false;
        }
        return PanelTopItem.getComponentsOn(candidate).isEmpty();
    }

    public static List<PlacedComponent> getComponentsOn(ItemStack panel) {
        CompoundTag fullNBT = panel.m_41783_();
        if (fullNBT == null) {
            return ImmutableList.of();
        }
        ListTag componentList = fullNBT.m_128437_(COMPONENTS_KEY, 10);
        return PlacedComponent.readListFromNBT((Tag)componentList);
    }

    public static ItemStack createWithComponents(List<PlacedComponent> components) {
        CompoundTag resultTag = new CompoundTag();
        resultTag.m_128365_(COMPONENTS_KEY, PlacedComponent.writeListToNBT(components));
        ItemStack resultStack = new ItemStack((ItemLike)CEItems.PANEL_TOP.get(), 1);
        resultStack.m_41751_(resultTag);
        return resultStack;
    }
}

