/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.client.ClientHooks;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.ItemNBTUtil;
import malte0811.controlengineering.util.TextUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PunchedTapeItem
extends Item {
    private static final String BYTES_KEY = "bytes";
    public static final String PUNCHED_TAPE_BYTES = "controlengineering.tooltip.written_tape_bytes";

    public PunchedTapeItem() {
        super(new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP).m_41487_(1));
    }

    public static ItemStack withBytes(byte[] bytes) {
        ItemStack result = ((PunchedTapeItem)((Object)CEItems.PUNCHED_TAPE.get())).m_7968_();
        PunchedTapeItem.setBytes(result, bytes);
        return result;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)PunchedTapeItem.setBytes(new ItemStack((ItemLike)this), BitUtils.toBytesWithParity("Test1")));
            items.add((Object)PunchedTapeItem.setBytes(new ItemStack((ItemLike)this), BitUtils.toBytesWithParity("Another test")));
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        byte[] data = PunchedTapeItem.getBytes(stack);
        TextUtil.addTooltipLine(tooltip, (MutableComponent)new TranslatableComponent(PUNCHED_TAPE_BYTES, new Object[]{data.length}));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            ClientHooks.openTape(PunchedTapeItem.getBytes(stack), handIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static byte[] getBytes(ItemStack tape) {
        return ItemNBTUtil.getTag(tape).map(c -> c.m_128463_(BYTES_KEY)).orElseGet(() -> new byte[0]);
    }

    public static ItemStack setBytes(ItemStack tape, byte[] newData) {
        tape.m_41784_().m_128382_(BYTES_KEY, newData);
        return tape;
    }
}

