/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.gui.CEContainers;
import malte0811.controlengineering.gui.logic.LogicDesignMenu;
import malte0811.controlengineering.items.ISchematicItem;
import malte0811.controlengineering.logic.schematic.Schematic;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SchematicItem
extends Item
implements ISchematicItem {
    public static final String EMPTY_SCHEMATIC = "controlengineering.gui.schematic.empty";

    public SchematicItem() {
        super(new Item.Properties().m_41491_(ControlEngineering.ITEM_GROUP));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.m_5776_()) {
            Schematic schematic = Objects.requireNonNullElseGet(ISchematicItem.getSchematic(stack), Schematic::new);
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, player1) -> new LogicDesignMenu(CEContainers.LOGIC_DESIGN_VIEW.get(), id, schematic), TextComponent.f_131282_));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag isAdvanced) {
        Schematic schematic = ISchematicItem.getSchematic(stack);
        if (Schematic.isEmpty(schematic)) {
            tooltipComponents.add((Component)new TranslatableComponent(EMPTY_SCHEMATIC).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        TranslatableComponent name = new TranslatableComponent(this.m_5671_(stack));
        Schematic schematic = ISchematicItem.getSchematic(stack);
        if (!Schematic.isEmpty(schematic)) {
            name.m_130946_(": " + schematic.getName());
        }
        return name;
    }
}

