/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.cells;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import net.minecraft.util.Mth;

public record CircuitSignals(Object2IntMap<String> signals) {
    public static final int MIN_VALID = -255;
    public static final int MAX_VALID = 255;

    public CircuitSignals {
        boolean modifiable = false;
        for (Object2IntMap.Entry entry : signals.object2IntEntrySet()) {
            if (CircuitSignals.isValid(entry.getIntValue())) continue;
            if (!modifiable) {
                signals = new Object2IntOpenHashMap(signals);
                modifiable = true;
            }
            signals.put((Object)((String)entry.getKey()), Mth.m_14045_((int)entry.getIntValue(), (int)-255, (int)255));
        }
    }

    public static CircuitSignals singleton(String name, int strength) {
        return new CircuitSignals((Object2IntMap<String>)Object2IntMaps.singleton((Object)name, (int)strength));
    }

    public static CircuitSignals singleton(String name, boolean strength) {
        return new CircuitSignals((Object2IntMap<String>)Object2IntMaps.singleton((Object)name, (int)CircuitSignals.debool(strength)));
    }

    public static CircuitSignals of(Map<String, Integer> values) {
        return new CircuitSignals((Object2IntMap<String>)new Object2IntOpenHashMap(values));
    }

    public static CircuitSignals ofBools(Map<String, Boolean> values) {
        Object2IntOpenHashMap signals = new Object2IntOpenHashMap();
        for (Map.Entry<String, Boolean> entry : values.entrySet()) {
            signals.put((Object)entry.getKey(), CircuitSignals.debool(entry.getValue()));
        }
        return new CircuitSignals((Object2IntMap<String>)signals);
    }

    public int value(String name) {
        return this.signals.getInt((Object)name);
    }

    public boolean bool(String name) {
        return CircuitSignals.bool(this.value(name));
    }

    public int size() {
        return this.signals.size();
    }

    public int numTrue() {
        int count = 0;
        IntIterator intIterator = this.signals.values().iterator();
        while (intIterator.hasNext()) {
            int signal = (Integer)intIterator.next();
            if (!CircuitSignals.bool(signal)) continue;
            ++count;
        }
        return count;
    }

    private static int debool(boolean in) {
        return in ? 255 : 0;
    }

    private static boolean bool(int in) {
        return in > 0;
    }

    public ObjectSet<Object2IntMap.Entry<String>> entries() {
        return this.signals.object2IntEntrySet();
    }

    private static boolean isValid(int strength) {
        return strength >= -255 && strength <= 255;
    }
}

