/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.cells.impl;

import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.cells.impl.StatelessCell;
import net.minecraft.world.phys.shapes.BooleanOp;

public class AssociativeFunctionCell
extends StatelessCell {
    private final BooleanOp func;
    private final boolean baseState;

    public AssociativeFunctionCell(int numInputs, LogicCircuitHandler.LogicCircuitOperator func, boolean baseState) {
        this(numInputs, (a, b) -> func.apply(new boolean[]{a, b}), baseState, CellCost.matchingIECosts(func, numInputs));
    }

    public AssociativeFunctionCell(int numInputs, BooleanOp func, boolean baseState, CellCost cost) {
        super(Pin.numbered(numInputs, "in", SignalType.DIGITAL, PinDirection.INPUT), (Map<String, Pin>)ImmutableMap.of((Object)"out", (Object)new Pin(SignalType.DIGITAL, PinDirection.OUTPUT)), cost);
        this.func = func;
        this.baseState = baseState;
    }

    @Override
    public CircuitSignals getOutputSignals(CircuitSignals inputSignals) {
        boolean result = this.baseState;
        int numTrue = inputSignals.numTrue();
        for (int i = 0; i < inputSignals.size(); ++i) {
            result = this.func.m_82701_(result, i < numTrue);
        }
        return CircuitSignals.singleton("out", result);
    }

    public BooleanOp getBaseFunction() {
        return this.func;
    }
}

