/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.cells.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.cells.impl.UnconfiguredCell;
import malte0811.controlengineering.util.mycodec.MyCodecs;

public class RSLatch
extends UnconfiguredCell<Boolean> {
    private static final Random RAND = new Random();
    public static final String RESET = "reset";
    public static final String SET = "set";
    public static final String Q = "q";
    public static final String NOT_Q = "not_q";

    public RSLatch() {
        super((Map<String, Pin>)ImmutableMap.of((Object)RESET, (Object)new Pin(SignalType.DIGITAL, PinDirection.INPUT), (Object)SET, (Object)new Pin(SignalType.DIGITAL, PinDirection.INPUT)), (Map<String, Pin>)ImmutableMap.of((Object)Q, (Object)new Pin(SignalType.DIGITAL, PinDirection.DELAYED_OUTPUT), (Object)NOT_Q, (Object)new Pin(SignalType.DIGITAL, PinDirection.DELAYED_OUTPUT)), false, MyCodecs.BOOL, new CellCost(5.0, 4.5));
    }

    @Override
    public Boolean nextState(CircuitSignals inputSignals, Boolean currentState) {
        boolean r = inputSignals.bool(RESET);
        boolean s = inputSignals.bool(SET);
        if (r && s) {
            return RAND.nextBoolean();
        }
        if (r) {
            return false;
        }
        if (s) {
            return true;
        }
        return currentState;
    }

    @Override
    public CircuitSignals getOutputSignals(CircuitSignals inputSignals, Boolean oldState) {
        return CircuitSignals.ofBools((Map<String, Boolean>)ImmutableMap.of((Object)Q, (Object)oldState, (Object)NOT_Q, (Object)(oldState == false ? 1 : 0)));
    }
}

