/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.cells.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.cells.impl.UnconfiguredCell;
import malte0811.controlengineering.util.mycodec.MyCodecs;

public class SchmittTrigger
extends UnconfiguredCell<Boolean> {
    public static final String LOW_PIN = "low";
    public static final String HIGH_PIN = "high";

    public SchmittTrigger() {
        super((Map<String, Pin>)ImmutableMap.of((Object)LOW_PIN, (Object)new Pin(SignalType.ANALOG, PinDirection.INPUT), (Object)"in", (Object)new Pin(SignalType.ANALOG, PinDirection.INPUT), (Object)HIGH_PIN, (Object)new Pin(SignalType.ANALOG, PinDirection.INPUT)), (Map<String, Pin>)ImmutableMap.of((Object)"out", (Object)new Pin(SignalType.DIGITAL, PinDirection.OUTPUT)), false, MyCodecs.BOOL, new CellCost(3.0, 4.0));
    }

    @Override
    public Boolean nextState(CircuitSignals inputSignals, Boolean currentState) {
        if (currentState.booleanValue()) {
            if (inputSignals.value("in") <= inputSignals.value(LOW_PIN)) {
                return false;
            }
        } else if (inputSignals.value("in") >= inputSignals.value(HIGH_PIN)) {
            return true;
        }
        return currentState;
    }

    @Override
    public CircuitSignals getOutputSignals(CircuitSignals inputSignals, Boolean oldState) {
        return CircuitSignals.singleton("out", this.nextState(inputSignals, oldState));
    }
}

