/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.cells.impl;

import java.util.Map;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.util.Unit;

public class VoltageDivider
extends LeafcellType<Unit, Integer> {
    public static final int TOTAL_RESISTANCE = 100;
    public static final MyCodec<Integer> RESISTANCE_CODEC = MyCodecs.INTEGER.copy();
    public static final String RESISTANCE_KEY = "controlengineering.gui.lower_resistance";
    public static final String INPUT_TOP = "input_a";
    public static final String INPUT_BOTTOM = "input_b";

    public VoltageDivider() {
        super(Map.of(INPUT_TOP, new Pin(SignalType.ANALOG, PinDirection.INPUT), INPUT_BOTTOM, new Pin(SignalType.ANALOG, PinDirection.INPUT)), Map.of("out", new Pin(SignalType.ANALOG, PinDirection.OUTPUT)), Unit.INSTANCE, MyCodecs.unit(Unit.INSTANCE), 50, RESISTANCE_CODEC, new CellCost(0.0, 4.0));
    }

    @Override
    public CircuitSignals getOutputSignals(CircuitSignals inputSignals, Unit oldState, Integer ratio) {
        int top = inputSignals.value(INPUT_TOP);
        int bottom = inputSignals.value(INPUT_BOTTOM);
        int out = (ratio * top + (100 - ratio) * bottom) / 100;
        return CircuitSignals.singleton("out", out);
    }
}

