/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.circuit;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.logic.cells.impl.Digitizer;
import malte0811.controlengineering.logic.circuit.Circuit;
import malte0811.controlengineering.logic.circuit.NetReference;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec3;
import net.minecraft.util.Mth;

public class BusConnectedCircuit {
    private static final MyCodec<Map<NetReference, List<BusSignalRef>>> OUTPUT_CONN_CODEC = MyCodecs.codecForMap(NetReference.CODEC, MyCodecs.list(BusSignalRef.CODEC));
    private static final MyCodec<Map<NetReference, Double>> CONSTANTS_CODEC = MyCodecs.codecForMap(NetReference.CODEC, MyCodecs.DOUBLE);
    public static final MyCodec<BusConnectedCircuit> CODEC = new RecordCodec3<BusConnectedCircuit, Circuit, Map<NetReference, List<BusSignalRef>>, List<InputConnection>>(new CodecField<BusConnectedCircuit, Circuit>("circuit", b -> b.circuit, Circuit.CODEC), new CodecField<BusConnectedCircuit, Map<NetReference, List<BusSignalRef>>>("outputs", b -> b.outputConnections, OUTPUT_CONN_CODEC), new CodecField<BusConnectedCircuit, List<InputConnection>>("inputs", b -> b.inputConnections, MyCodecs.list(InputConnection.CODEC)), BusConnectedCircuit::new);
    private final Circuit circuit;
    private final Map<NetReference, List<BusSignalRef>> outputConnections;
    private final List<InputConnection> inputConnections;
    private BusState outputValues = BusState.EMPTY;

    public BusConnectedCircuit(Circuit circuit, Map<NetReference, List<BusSignalRef>> outputConnections, List<InputConnection> inputConnections) {
        this.circuit = circuit;
        this.outputConnections = outputConnections;
        this.inputConnections = inputConnections;
        this.propagateToOutputs();
    }

    public BusConnectedCircuit(Circuit circuit, Map<NetReference, List<BusSignalRef>> outputConnections, List<InputConnection> inputConnections, Map<NetReference, Integer> constantInputs) {
        this(circuit, outputConnections, inputConnections);
        Preconditions.checkArgument((boolean)inputConnections.stream().map(InputConnection::connectedNets).flatMap(Collection::stream).noneMatch(constantInputs::containsKey));
        constantInputs.forEach(circuit::updateInputValue);
        this.propagateToOutputs();
    }

    public void updateInputs(BusState bus) {
        for (InputConnection input : this.inputConnections) {
            int rawValue = bus.getSignal(input.busSignal());
            int realValue = input.digitized() ? Digitizer.digitize(rawValue) : rawValue;
            for (NetReference circuitNet : input.connectedNets()) {
                this.circuit.updateInputValue(circuitNet, realValue);
            }
        }
    }

    public boolean tick() {
        this.circuit.tick();
        return this.propagateToOutputs();
    }

    private boolean propagateToOutputs() {
        boolean changed = false;
        for (Map.Entry<NetReference, List<BusSignalRef>> output : this.outputConnections.entrySet()) {
            int newValue = Mth.m_14045_((int)this.circuit.getNetValue(output.getKey()), (int)0, (int)255);
            for (BusSignalRef busSignal : output.getValue()) {
                int currentValue = this.outputValues.getSignal(busSignal);
                if (currentValue == newValue) continue;
                this.outputValues = this.outputValues.with(busSignal, newValue);
                changed = true;
            }
        }
        return changed;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public BusState getOutputState() {
        return this.outputValues;
    }

    public record InputConnection(BusSignalRef busSignal, List<NetReference> connectedNets, boolean digitized) {
        public static final MyCodec<InputConnection> CODEC = new RecordCodec3<InputConnection, BusSignalRef, List<NetReference>, Boolean>(new CodecField<InputConnection, BusSignalRef>("signal", InputConnection::busSignal, BusSignalRef.CODEC), new CodecField<InputConnection, List<NetReference>>("nets", InputConnection::connectedNets, MyCodecs.list(NetReference.CODEC)), new CodecField<InputConnection, Boolean>("digitized", InputConnection::digitized, MyCodecs.BOOL), InputConnection::new);
    }
}

