/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.circuit;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.LeafcellInstance;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.circuit.NetReference;
import malte0811.controlengineering.logic.circuit.PinReference;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import malte0811.controlengineering.util.mycodec.record.RecordCodec4;

public class Circuit {
    private static final MyCodec<List<PlacedLeafcell>> CELLS_CODEC = MyCodecs.list(PlacedLeafcell.CODEC);
    private static final MyCodec<Object2IntMap<NetReference>> NET_VALUES_CODEC = MyCodecs.codecForMap(NetReference.CODEC, MyCodecs.INTEGER).xmap(Object2IntOpenHashMap::new, m -> m);
    private static final MyCodec<Map<PinReference, NetReference>> PIN_NET_CODEC = MyCodecs.codecForMap(PinReference.CODEC, NetReference.CODEC);
    public static final MyCodec<Circuit> CODEC = new RecordCodec4<Circuit, List<PlacedLeafcell>, Object2IntMap<NetReference>, Map<PinReference, NetReference>, Object2IntMap<NetReference>>(new CodecField<Circuit, List<PlacedLeafcell>>("cellsInOrder", c -> c.cellsInTopoOrder, CELLS_CODEC), new CodecField<Circuit, Object2IntMap<NetReference>>("inputValues", c -> c.inputValues, NET_VALUES_CODEC), new CodecField<Circuit, Map<PinReference, NetReference>>("pinToNet", c -> c.pinToNet, PIN_NET_CODEC), new CodecField<Circuit, Object2IntMap<NetReference>>("allNetValues", c -> c.allNetValues, NET_VALUES_CODEC), Circuit::new);
    private final List<PlacedLeafcell> cellsInTopoOrder;
    private final Object2IntMap<NetReference> allNetValues;
    private final Object2IntMap<NetReference> inputValues;
    private final Map<NetReference, PinReference> delayedNetsBySource;
    private final Map<PinReference, NetReference> pinToNet;

    public Circuit(List<PlacedLeafcell> cellsInOrder, Set<NetReference> inputs, Map<PinReference, NetReference> pinNets) {
        this(cellsInOrder, (Object2IntMap<NetReference>)new Object2IntOpenHashMap(inputs.stream().collect(Collectors.toMap(Function.identity(), $ -> 0))), pinNets, (Object2IntMap<NetReference>)new Object2IntOpenHashMap());
    }

    public Circuit(List<PlacedLeafcell> cellsInOrder, Object2IntMap<NetReference> inputs, Map<PinReference, NetReference> pinNets, Object2IntMap<NetReference> netValues) {
        this.cellsInTopoOrder = cellsInOrder;
        this.pinToNet = pinNets;
        this.inputValues = inputs;
        HashMap<NetReference, PinReference> delayedSources = new HashMap<NetReference, PinReference>();
        for (Map.Entry<PinReference, NetReference> entry : pinNets.entrySet()) {
            Map<String, Pin> pins;
            if (!entry.getKey().isOutput() || (pins = cellsInOrder.get(entry.getKey().cell()).getType().getOutputPins()).get(entry.getKey().pinName()).direction().isCombinatorialOutput()) continue;
            delayedSources.put(entry.getValue(), entry.getKey());
        }
        this.delayedNetsBySource = delayedSources;
        this.allNetValues = netValues;
    }

    public int getNetValue(NetReference net) {
        return this.allNetValues.getInt((Object)net);
    }

    public void updateInputValue(NetReference net, int value) {
        Preconditions.checkArgument((boolean)this.inputValues.containsKey((Object)net));
        this.inputValues.put((Object)net, value);
    }

    public void tick() {
        this.allNetValues.clear();
        this.allNetValues.putAll(this.inputValues);
        for (Map.Entry<NetReference, PinReference> delayedNet : this.delayedNetsBySource.entrySet()) {
            NetReference net = delayedNet.getKey();
            PinReference pin = delayedNet.getValue();
            PlacedLeafcell cell = this.cellsInTopoOrder.get(pin.cell());
            this.allNetValues.put((Object)net, cell.getCurrentOutput(this.getCellInputs(pin.cell())).value(pin.pinName()));
        }
        for (int cellId = 0; cellId < this.cellsInTopoOrder.size(); ++cellId) {
            PlacedLeafcell cell = this.cellsInTopoOrder.get(cellId);
            for (Object2IntMap.Entry entry : cell.tick(this.getCellInputs(cellId)).entries()) {
                NetReference net = this.pinToNet.get(new PinReference(cellId, true, (String)entry.getKey()));
                if (net == null) continue;
                Pin pin = cell.getType().getOutputPins().get(entry.getKey());
                if (pin.direction().isCombinatorialOutput()) {
                    Preconditions.checkState((!this.allNetValues.containsKey((Object)net) ? 1 : 0) != 0);
                    this.allNetValues.put((Object)net, entry.getIntValue());
                    continue;
                }
                Preconditions.checkState((boolean)this.allNetValues.containsKey((Object)net));
            }
        }
    }

    private CircuitSignals getCellInputs(int cellId) {
        PlacedLeafcell cell = this.cellsInTopoOrder.get(cellId);
        Object2IntOpenHashMap inputValues = new Object2IntOpenHashMap();
        for (Map.Entry<String, Pin> entry : cell.getType().getInputPins().entrySet()) {
            NetReference netAtInput = this.pinToNet.get(new PinReference(cellId, false, entry.getKey()));
            inputValues.put((Object)entry.getKey(), this.allNetValues.getInt((Object)netAtInput));
        }
        return new CircuitSignals((Object2IntMap<String>)inputValues);
    }

    public List<PlacedLeafcell> getCells() {
        return Collections.unmodifiableList(this.cellsInTopoOrder);
    }

    public record PlacedLeafcell(LeafcellInstance<?, ?> cell, Vec2i pos) {
        public static MyCodec<PlacedLeafcell> CODEC = new RecordCodec2<PlacedLeafcell, LeafcellInstance, Vec2i>(new CodecField("cell", PlacedLeafcell::cell, LeafcellInstance.CODEC), new CodecField<PlacedLeafcell, Vec2i>("pos", PlacedLeafcell::pos, Vec2i.CODEC), PlacedLeafcell::new).orElse(LeafcellInstance.CODEC.xmap(c -> new PlacedLeafcell((LeafcellInstance<?, ?>)c, Vec2i.ZERO), PlacedLeafcell::cell));

        public LeafcellType<?, ?> getType() {
            return (LeafcellType)this.cell.getType();
        }

        public CircuitSignals getCurrentOutput(CircuitSignals cellInputs) {
            return this.cell.getCurrentOutput(cellInputs);
        }

        public CircuitSignals tick(CircuitSignals cellInputs) {
            return this.cell.tick(cellInputs);
        }
    }
}

