/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.circuit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import malte0811.controlengineering.logic.cells.LeafcellInstance;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.cells.Pin;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.circuit.Circuit;
import malte0811.controlengineering.logic.circuit.NetReference;
import malte0811.controlengineering.logic.circuit.PinReference;
import malte0811.controlengineering.util.math.Vec2i;

public class CircuitBuilder {
    private final List<Circuit.PlacedLeafcell> cells = new ArrayList<Circuit.PlacedLeafcell>();
    private final Map<PinReference, NetReference> pins = new HashMap<PinReference, NetReference>();
    private final Set<NetReference> existingNets = new HashSet<NetReference>();
    private final Set<NetReference> analogNets = new HashSet<NetReference>();
    private final Set<NetReference> inputNets = new HashSet<NetReference>();
    private final Set<NetReference> openDelayedNets = new HashSet<NetReference>();

    public static CircuitBuilder builder() {
        return new CircuitBuilder();
    }

    public CellBuilder addCell(LeafcellInstance<?, ?> cell, Vec2i pos) {
        return new CellBuilder(cell, pos);
    }

    public CircuitBuilder addInputNet(NetReference input, SignalType type) {
        this.inputNets.add(input);
        this.addNet(input, type);
        return this;
    }

    public CircuitBuilder addDelayedNet(NetReference delayed, SignalType type) {
        this.addNet(delayed, type);
        this.openDelayedNets.add(delayed);
        return this;
    }

    private void addNet(NetReference net, SignalType type) {
        Preconditions.checkState((!this.existingNets.contains(net) ? 1 : 0) != 0);
        this.existingNets.add(net);
        if (type == SignalType.ANALOG) {
            this.analogNets.add(net);
        }
    }

    public Circuit build() {
        Preconditions.checkState((boolean)this.openDelayedNets.isEmpty());
        return new Circuit(this.cells, this.inputNets, this.pins);
    }

    public class CellBuilder {
        private final LeafcellInstance<?, ?> cell;
        private Vec2i pos;
        private final Map<PinReference, NetReference> cellPins = new HashMap<PinReference, NetReference>();
        private final Set<NetReference> outputNets = new HashSet<NetReference>();

        public CellBuilder(LeafcellInstance<?, ?> cell, Vec2i pos) {
            this.cell = cell;
            this.pos = pos;
        }

        public CellBuilder output(String name, NetReference net) {
            Preconditions.checkState((!CircuitBuilder.this.existingNets.contains(net) || CircuitBuilder.this.openDelayedNets.contains(net) ? 1 : 0) != 0);
            Preconditions.checkState((!this.outputNets.contains(net) ? 1 : 0) != 0);
            Preconditions.checkState((!this.cellPins.containsValue(net) ? 1 : 0) != 0);
            Preconditions.checkState((boolean)((LeafcellType)this.cell.getType()).getOutputPins().containsKey(name));
            this.cellPins.put(new PinReference(CircuitBuilder.this.cells.size(), true, name), net);
            this.outputNets.add(net);
            return this;
        }

        public CellBuilder input(String name, NetReference net) {
            Preconditions.checkState((boolean)CircuitBuilder.this.existingNets.contains(net));
            Pin cellPin = ((LeafcellType)this.cell.getType()).getInputPins().get(name);
            Preconditions.checkNotNull((Object)cellPin);
            if (cellPin.type() == SignalType.DIGITAL) {
                Preconditions.checkState((!CircuitBuilder.this.analogNets.contains(net) ? 1 : 0) != 0);
            }
            this.cellPins.put(new PinReference(CircuitBuilder.this.cells.size(), false, name), net);
            return this;
        }

        public CircuitBuilder buildCell() {
            long numConnectedInputs = this.cellPins.keySet().stream().filter(p -> !p.isOutput()).count();
            Preconditions.checkState((numConnectedInputs == (long)((LeafcellType)this.cell.getType()).getInputPins().size() ? 1 : 0) != 0);
            CircuitBuilder.this.cells.add(new Circuit.PlacedLeafcell(this.cell, this.pos));
            CircuitBuilder.this.pins.putAll(this.cellPins);
            for (Map.Entry<PinReference, NetReference> e : this.cellPins.entrySet()) {
                if (!e.getKey().isOutput()) continue;
                Pin cellPin = ((LeafcellType)this.cell.getType()).getOutputPins().get(e.getKey().pinName());
                if (cellPin.direction().isCombinatorialOutput() || !CircuitBuilder.this.openDelayedNets.contains(e.getValue())) {
                    CircuitBuilder.this.addNet(e.getValue(), cellPin.type());
                    continue;
                }
                CircuitBuilder.this.openDelayedNets.remove(e.getValue());
            }
            return CircuitBuilder.this;
        }
    }
}

