/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.clock;

import malte0811.controlengineering.logic.clock.ClockTypes;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.typereg.TypedInstance;
import malte0811.controlengineering.util.typereg.TypedRegistryEntry;

public abstract class ClockGenerator<State>
extends TypedRegistryEntry<State, ClockInstance<State>> {
    protected ClockGenerator(State initialState, MyCodec<State> stateCodec) {
        super(initialState, stateCodec);
    }

    public abstract boolean shouldTick(State var1, boolean var2);

    public abstract State nextState(State var1, boolean var2);

    @Override
    public ClockInstance<State> newInstance(State state) {
        return new ClockInstance<State>(this, state);
    }

    public boolean isActiveClock() {
        return true;
    }

    public static class ClockInstance<State>
    extends TypedInstance<State, ClockGenerator<State>> {
        public static final MyCodec<ClockInstance<?>> CODEC = TypedInstance.makeCodec(ClockTypes.REGISTRY);

        public ClockInstance(ClockGenerator<State> stateClockGenerator, State currentState) {
            super(stateClockGenerator, currentState);
        }

        public boolean tick(boolean triggerIn) {
            Object nextState = ((ClockGenerator)this.getType()).nextState(this.getCurrentState(), triggerIn);
            boolean result = ((ClockGenerator)this.getType()).shouldTick(this.getCurrentState(), triggerIn);
            this.currentState = nextState;
            return result;
        }
    }
}

