/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.clock;

import java.util.Map;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.logic.clock.ClockGenerator;
import malte0811.controlengineering.logic.clock.EdgeClock;
import malte0811.controlengineering.logic.clock.FreeClock;
import malte0811.controlengineering.logic.clock.NoneClock;
import malte0811.controlengineering.logic.clock.StateClock;
import malte0811.controlengineering.util.typereg.TypedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;

public class ClockTypes {
    public static final ClockGenerator<Unit> ALWAYS_ON = new FreeClock();
    public static final ClockGenerator<Boolean> RISING_EDGE = new EdgeClock();
    public static final ClockGenerator<Unit> WHILE_RS_ON = new StateClock();
    public static final ClockGenerator<Unit> NEVER = new NoneClock();
    public static final TypedRegistry<ClockGenerator<?>> REGISTRY = new TypedRegistry();

    public static <T extends ClockGenerator<?>> T register(ResourceLocation name, T generator) {
        return REGISTRY.register(name, generator);
    }

    public static Map<ResourceLocation, ClockGenerator<?>> getGenerators() {
        return REGISTRY.getEntries();
    }

    public static Item getItem(ClockGenerator<?> clock) {
        return (Item)CEItems.CLOCK_GENERATORS.get(clock.getRegistryName()).get();
    }

    static {
        ClockTypes.register(new ResourceLocation("controlengineering", "clock_free"), ALWAYS_ON);
        ClockTypes.register(new ResourceLocation("controlengineering", "clock_edge"), RISING_EDGE);
        ClockTypes.register(new ResourceLocation("controlengineering", "clock_state"), WHILE_RS_ON);
        ClockTypes.register(new ResourceLocation("controlengineering", "clock_none"), NEVER);
    }
}

