/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.schematic.ConnectedPin;
import malte0811.controlengineering.logic.schematic.SchematicChecker;
import malte0811.controlengineering.logic.schematic.SchematicNet;
import malte0811.controlengineering.logic.schematic.WireSegment;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.util.math.RectangleI;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec3;
import malte0811.controlengineering.util.typereg.TypedInstance;
import net.minecraft.world.level.Level;

public class Schematic {
    public static final int GLOBAL_MIN = -512;
    public static final int GLOBAL_MAX = 512;
    public static final RectangleI BOUNDARY = new RectangleI(-512, -512, 512, 512);
    public static final MyCodec<Schematic> CODEC = new RecordCodec3<Schematic, List<PlacedSymbol>, List<SchematicNet>, String>(new CodecField<Schematic, List<PlacedSymbol>>("symbols", Schematic::getSymbols, MyCodecs.list(PlacedSymbol.CODEC)), new CodecField<Schematic, List<SchematicNet>>("nets", Schematic::getNets, MyCodecs.list(SchematicNet.CODEC)), new CodecField<Schematic, String>("name", Schematic::getName, MyCodecs.STRING), Schematic::new);
    private final List<PlacedSymbol> symbols;
    private final List<SchematicNet> nets;
    private String name;

    private Schematic(List<PlacedSymbol> symbols, List<SchematicNet> nets, String name) {
        this.symbols = new ArrayList<PlacedSymbol>(symbols);
        this.nets = new ArrayList<SchematicNet>(nets);
        this.name = name;
        this.resetConnectedPins();
    }

    public Schematic() {
        this((List<PlacedSymbol>)ImmutableList.of(), (List<SchematicNet>)ImmutableList.of(), "New schematic");
    }

    public boolean addSymbol(PlacedSymbol newSymbol, Level level) {
        if (!this.makeChecker(level).canAdd(newSymbol)) {
            return false;
        }
        this.symbols.add(newSymbol);
        this.resetConnectedPins();
        return true;
    }

    public void addWire(WireSegment segment) {
        IntSet connectedIndices = this.getConnectedNetIndices(segment);
        if (connectedIndices.isEmpty()) {
            this.nets.add(new SchematicNet(segment));
        } else {
            IntIterator it = connectedIndices.iterator();
            int netIdToKeep = it.nextInt();
            SchematicNet netToKeep = this.nets.get(netIdToKeep);
            while (it.hasNext()) {
                SchematicNet netToRemove = this.nets.remove(it.nextInt());
                netToKeep.addAll(netToRemove);
            }
            netToKeep.addSegment(segment);
        }
        this.resetConnectedPins();
    }

    public boolean removeOneContaining(Vec2d mouse, Level level) {
        Iterator<Object> iterator = this.nets.iterator();
        while (iterator.hasNext()) {
            SchematicNet net = iterator.next();
            if (!net.removeOneContaining(mouse.floor())) continue;
            iterator.remove();
            this.nets.addAll(net.splitComponents());
            this.resetConnectedPins();
            return true;
        }
        iterator = this.symbols.iterator();
        while (iterator.hasNext()) {
            if (!((PlacedSymbol)iterator.next()).containsPoint(mouse, level)) continue;
            iterator.remove();
            this.resetConnectedPins();
            return true;
        }
        return false;
    }

    private boolean isConnected(SchematicNet net, WireSegment wire) {
        for (Vec2i end : wire.getEnds()) {
            if (!net.contains(end)) continue;
            return true;
        }
        for (WireSegment netWire : net.getAllSegments()) {
            for (Vec2i netEnd : netWire.getEnds()) {
                if (!wire.containsClosed(netEnd)) continue;
                return true;
            }
        }
        for (ConnectedPin pin : net.getOrComputePins(this.getSymbols())) {
            if (!wire.containsClosed(pin.getPosition())) continue;
            return true;
        }
        return false;
    }

    public IntSet getConnectedNetIndices(WireSegment toAdd) {
        IntArraySet indices = new IntArraySet();
        for (int i = 0; i < this.nets.size(); ++i) {
            if (!this.isConnected(this.nets.get(i), toAdd)) continue;
            indices.add(i);
        }
        return indices;
    }

    @Nullable
    public PlacedSymbol getSymbolAt(Vec2d pos, Level level) {
        for (PlacedSymbol symbol : this.symbols) {
            if (!symbol.containsPoint(pos, level)) continue;
            return symbol;
        }
        return null;
    }

    private void resetConnectedPins() {
        this.nets.forEach(SchematicNet::resetCachedPins);
    }

    public List<PlacedSymbol> getSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }

    public List<SchematicNet> getNets() {
        return Collections.unmodifiableList(this.nets);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SchematicChecker makeChecker(Level level) {
        return new SchematicChecker(this, level);
    }

    private int getTotalCost(ToDoubleFunction<CellCost> individualCost) {
        return (int)Math.ceil(this.getSymbols().stream().map(PlacedSymbol::symbol).map(TypedInstance::getType).map(SchematicSymbol::getCost).mapToDouble(individualCost).sum());
    }

    public int getNumLogicTubes() {
        return this.getTotalCost(CellCost::numTubes);
    }

    public int getWireLength() {
        return this.getTotalCost(CellCost::wireLength);
    }

    public int getSolderAmount() {
        return this.getTotalCost(CellCost::getSolderAmount);
    }

    public void clear() {
        this.symbols.clear();
        this.nets.clear();
    }

    public boolean replaceBy(int index, PlacedSymbol newSymbol, Level level) {
        PlacedSymbol oldSymbol = this.symbols.remove(index);
        this.resetConnectedPins();
        if (this.addSymbol(newSymbol, level)) {
            return true;
        }
        this.addSymbol(oldSymbol, level);
        return false;
    }

    public boolean isEmpty() {
        return this.symbols.isEmpty() && this.nets.isEmpty();
    }

    public static boolean isEmpty(@Nullable Schematic schematic) {
        return schematic == null || schematic.isEmpty();
    }
}

