/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import malte0811.controlengineering.logic.schematic.ConnectedPin;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicCircuitConverter;
import malte0811.controlengineering.logic.schematic.SchematicNet;
import malte0811.controlengineering.logic.schematic.WireSegment;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;

public record SchematicChecker(Schematic schematic, Level level) {
    public static final String WIRE_OUTSIDE_BOUNDARY = "controlengineering.gui.wireOutsideBoundary";
    public static final String SYMBOL_OUTSIDE_BOUNDARY = "controlengineering.gui.symbolOutsideBoundary";
    public static final String MULTIPLE_SOURCES = "controlengineering.gui.multipleSources";
    public static final String CYCLE = "controlengineering.gui.cycle";
    public static final String ANALOG_DIGITAL_MIX = "controlengineering.gui.analogVsDigital";
    public static final String SYMBOL_INTERSECTION = "controlengineering.gui.symbolIntersection";

    public Optional<Component> getErrorForAdding(WireSegment segment) {
        if (!Schematic.BOUNDARY.containsClosed(segment.start()) || !Schematic.BOUNDARY.containsClosed(segment.end())) {
            return SchematicChecker.error(WIRE_OUTSIDE_BOUNDARY);
        }
        IntSet netsToCheck = this.schematic.getConnectedNetIndices(segment);
        Set<ConnectedPin> wirePins = new SchematicNet(segment).computeConnectedPins(this.schematic.getSymbols());
        HashSet<ConnectedPin> allPins = new HashSet<ConnectedPin>(wirePins);
        IntIterator intIterator = netsToCheck.iterator();
        while (intIterator.hasNext()) {
            int netId = (Integer)intIterator.next();
            SchematicNet net = this.schematic.getNets().get(netId);
            allPins.addAll(net.getOrComputePins(this.schematic.getSymbols()));
        }
        Optional<Component> consistency = SchematicChecker.getConsistencyError(allPins);
        if (consistency.isPresent()) {
            return consistency;
        }
        if (netsToCheck.size() + wirePins.size() > 1) {
            ArrayList<Collection<ConnectedPin>> nets = new ArrayList<Collection<ConnectedPin>>();
            nets.add(new ArrayList<ConnectedPin>(allPins));
            for (int i = 0; i < this.schematic.getNets().size(); ++i) {
                if (netsToCheck.contains(i)) continue;
                nets.add(this.schematic.getNets().get(i).getOrComputePins(this.schematic.getSymbols()));
            }
            if (SchematicCircuitConverter.getCellOrder(this.schematic.getSymbols(), SchematicCircuitConverter.getNetsBySource(nets)).isEmpty()) {
                return SchematicChecker.error(CYCLE);
            }
        }
        return Optional.empty();
    }

    public boolean canAdd(WireSegment segment) {
        return this.getErrorForAdding(segment).isEmpty();
    }

    public static Optional<Component> getConsistencyError(Set<ConnectedPin> netPins) {
        ConnectedPin sourcePin = null;
        boolean hasAnalogSource = false;
        boolean hasDigitalSink = false;
        for (ConnectedPin pin : netPins) {
            if (pin.pin().isOutput()) {
                if (sourcePin != null) {
                    return SchematicChecker.error(MULTIPLE_SOURCES);
                }
                sourcePin = pin;
                if (!pin.isAnalog()) continue;
                hasAnalogSource = true;
                continue;
            }
            if (pin.isAnalog()) continue;
            hasDigitalSink = true;
        }
        if (hasAnalogSource && hasDigitalSink) {
            return SchematicChecker.error(ANALOG_DIGITAL_MIX);
        }
        return Optional.empty();
    }

    public Optional<Component> getErrorForAdding(PlacedSymbol candidate) {
        if (!Schematic.BOUNDARY.contains(candidate.getShape(this.level))) {
            return SchematicChecker.error(SYMBOL_OUTSIDE_BOUNDARY);
        }
        if (!this.schematic.getSymbols().stream().allMatch(other -> candidate.canCoexist((PlacedSymbol)other, this.level))) {
            return SchematicChecker.error(SYMBOL_INTERSECTION);
        }
        ArrayList<HashSet<ConnectedPin>> nets = new ArrayList<HashSet<ConnectedPin>>();
        for (SchematicNet net : this.schematic.getNets()) {
            HashSet<ConnectedPin> pinsInNet = new HashSet<ConnectedPin>(net.getOrComputePins(this.schematic.getSymbols()));
            pinsInNet.addAll(net.computeConnectedPins(Collections.singletonList(candidate)));
            Optional<Component> netConsistency = SchematicChecker.getConsistencyError(pinsInNet);
            if (netConsistency.isPresent()) {
                return netConsistency;
            }
            nets.add(pinsInNet);
        }
        ArrayList<PlacedSymbol> allSymbols = new ArrayList<PlacedSymbol>(this.schematic.getSymbols());
        allSymbols.add(candidate);
        if (SchematicCircuitConverter.getCellOrder(allSymbols, SchematicCircuitConverter.getNetsBySource(nets)).isEmpty()) {
            return SchematicChecker.error(CYCLE);
        }
        return Optional.empty();
    }

    public boolean canAdd(PlacedSymbol candidate) {
        return this.getErrorForAdding(candidate).isEmpty();
    }

    private static Optional<Component> error(String translationKey) {
        return Optional.of(new TranslatableComponent(translationKey));
    }
}

