/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.circuit.BusConnectedCircuit;
import malte0811.controlengineering.logic.circuit.CircuitBuilder;
import malte0811.controlengineering.logic.circuit.NetReference;
import malte0811.controlengineering.logic.schematic.ConnectedPin;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicNet;
import malte0811.controlengineering.logic.schematic.symbol.CellSymbol;
import malte0811.controlengineering.logic.schematic.symbol.IOSymbol;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import malte0811.controlengineering.logic.schematic.symbol.SymbolInstance;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;

public class SchematicCircuitConverter {
    private static Map<NetReference, List<ConnectedPin>> getPinsByNet(Schematic schematic) {
        HashMap<NetReference, List<ConnectedPin>> result = new HashMap<NetReference, List<ConnectedPin>>();
        for (SchematicNet net : schematic.getNets()) {
            Set<ConnectedPin> allPins = net.getOrComputePins(schematic.getSymbols());
            if (allPins.isEmpty()) continue;
            ArrayList<ConnectedPin> asList = new ArrayList<ConnectedPin>(allPins);
            result.put(new NetReference(((ConnectedPin)asList.get(0)).getPosition().toString()), asList);
        }
        return result;
    }

    @Nullable
    private static Pair<ConnectedPin, List<ConnectedPin>> splitSourceFromSinks(Collection<ConnectedPin> allPins) {
        Optional<ConnectedPin> source = SchematicCircuitConverter.getSource(allPins);
        if (!source.isPresent()) {
            return null;
        }
        return Pair.of((Object)source.get(), SchematicCircuitConverter.getSinks(allPins));
    }

    public static Map<ConnectedPin, List<ConnectedPin>> getNetsBySource(Collection<? extends Collection<ConnectedPin>> nets) {
        return nets.stream().map(SchematicCircuitConverter::splitSourceFromSinks).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static List<ConnectedPin> getFloatingInputs(Schematic schematic) {
        return SchematicCircuitConverter.getFloatingInputs(schematic.getSymbols(), SchematicCircuitConverter.getPinsByNet(schematic).values());
    }

    public static List<ConnectedPin> getFloatingInputs(List<PlacedSymbol> symbols, Collection<List<ConnectedPin>> nets) {
        HashSet<ConnectedPin> pinsWithoutNet = new HashSet<ConnectedPin>();
        for (PlacedSymbol placedSymbol : symbols) {
            for (SymbolPin pin2 : placedSymbol.symbol().getPins()) {
                pinsWithoutNet.add(new ConnectedPin(placedSymbol, pin2));
            }
        }
        for (List list : nets) {
            if (!SchematicCircuitConverter.getSource(list).isPresent()) continue;
            for (ConnectedPin pin2 : list) {
                pinsWithoutNet.remove(pin2);
            }
        }
        pinsWithoutNet.removeIf(pin -> pin.pin().isOutput());
        return new ArrayList<ConnectedPin>(pinsWithoutNet);
    }

    public static Optional<List<PlacedSymbol>> getCellOrder(Schematic schematic) {
        Map<NetReference, List<ConnectedPin>> nets = SchematicCircuitConverter.getPinsByNet(schematic);
        return SchematicCircuitConverter.getCellOrder(schematic.getSymbols(), SchematicCircuitConverter.getNetsBySource(nets.values()));
    }

    public static Optional<List<PlacedSymbol>> getCellOrder(List<PlacedSymbol> symbols, Map<ConnectedPin, List<ConnectedPin>> nets) {
        MutableGraph graph = GraphBuilder.directed().expectedNodeCount(symbols.size()).build();
        for (PlacedSymbol placedSymbol : symbols) {
            graph.addNode((Object)placedSymbol);
        }
        for (Map.Entry entry : nets.entrySet()) {
            if (!((ConnectedPin)entry.getKey()).pin().isCombinatorialOutput()) continue;
            PlacedSymbol source = ((ConnectedPin)entry.getKey()).symbol();
            for (ConnectedPin sink : (List)entry.getValue()) {
                if (source == sink.symbol()) {
                    return Optional.empty();
                }
                graph.putEdge((Object)source, (Object)sink.symbol());
            }
        }
        try {
            return Optional.of(TopologicalSort.topologicalSort((Graph)graph, null));
        }
        catch (CyclePresentException x) {
            return Optional.empty();
        }
    }

    private static Map<ConnectedPin, NetReference> toPinNetMap(Map<NetReference, List<ConnectedPin>> netsBySource) {
        HashMap<ConnectedPin, NetReference> result = new HashMap<ConnectedPin, NetReference>();
        for (Map.Entry<NetReference, List<ConnectedPin>> entry : netsBySource.entrySet()) {
            for (ConnectedPin sink : entry.getValue()) {
                result.put(sink, entry.getKey());
            }
        }
        return result;
    }

    private static Optional<ConnectedPin> getSource(Collection<ConnectedPin> netPins) {
        return netPins.stream().filter(p -> p.pin().isOutput()).findAny();
    }

    private static List<ConnectedPin> getSinks(Collection<ConnectedPin> netPins) {
        return netPins.stream().filter(p -> !p.pin().isOutput()).collect(Collectors.toList());
    }

    private static <T> Map<NetReference, T> getNetsWithSource(Map<NetReference, List<ConnectedPin>> nets, SchematicSymbol<T> sourceType) {
        HashMap result = new HashMap();
        for (Map.Entry<NetReference, List<ConnectedPin>> entry : nets.entrySet()) {
            SymbolInstance<?> symbol;
            Optional<ConnectedPin> source = SchematicCircuitConverter.getSource((Collection<ConnectedPin>)entry.getValue());
            if (!source.isPresent() || (symbol = source.get().symbol().symbol()).getType() != sourceType) continue;
            result.put(entry.getKey(), symbol.getCurrentState());
        }
        return result;
    }

    private static List<BusConnectedCircuit.InputConnection> getInputConnections(Map<NetReference, List<ConnectedPin>> nets) {
        record Input(BusSignalRef busSignal, boolean digital) {
        }
        HashMap netsByInput = new HashMap();
        BiConsumer<Map.Entry, Boolean> add = (entry, digital) -> netsByInput.computeIfAbsent(new Input((BusSignalRef)entry.getValue(), (boolean)digital), $ -> new ArrayList()).add((NetReference)entry.getKey());
        for (Map.Entry<NetReference, BusSignalRef> entry2 : SchematicCircuitConverter.getNetsWithSource(nets, SchematicSymbols.INPUT_PIN_ANALOG).entrySet()) {
            add.accept(entry2, false);
        }
        for (Map.Entry<NetReference, BusSignalRef> entry2 : SchematicCircuitConverter.getNetsWithSource(nets, SchematicSymbols.INPUT_PIN_DIGITAL).entrySet()) {
            add.accept(entry2, true);
        }
        return netsByInput.entrySet().stream().map(e -> new BusConnectedCircuit.InputConnection(((Input)e.getKey()).busSignal(), (List)e.getValue(), ((Input)e.getKey()).digital)).toList();
    }

    private static Map<NetReference, Integer> getConstantNets(Map<NetReference, List<ConnectedPin>> nets) {
        return SchematicCircuitConverter.getNetsWithSource(nets, SchematicSymbols.CONSTANT);
    }

    private static Map<NetReference, List<BusSignalRef>> getOutputConnections(Map<NetReference, List<ConnectedPin>> nets) {
        HashMap<NetReference, List<BusSignalRef>> result = new HashMap<NetReference, List<BusSignalRef>>();
        for (Map.Entry<NetReference, List<ConnectedPin>> entry : nets.entrySet()) {
            for (ConnectedPin sink : SchematicCircuitConverter.getSinks((Collection<ConnectedPin>)entry.getValue())) {
                SymbolInstance<?> symbol = sink.symbol().symbol();
                if (!(symbol.getType() instanceof IOSymbol)) continue;
                result.computeIfAbsent(entry.getKey(), $ -> new ArrayList()).add((BusSignalRef)symbol.getCurrentState());
            }
        }
        return result;
    }

    public static Optional<BusConnectedCircuit> toCircuit(Schematic schematic) {
        Map<NetReference, List<ConnectedPin>> nets = SchematicCircuitConverter.getPinsByNet(schematic);
        if (!SchematicCircuitConverter.getFloatingInputs(schematic.getSymbols(), nets.values()).isEmpty()) {
            return Optional.empty();
        }
        Map<ConnectedPin, NetReference> pinsToNet = SchematicCircuitConverter.toPinNetMap(nets);
        Map<NetReference, List<BusSignalRef>> outputConnections = SchematicCircuitConverter.getOutputConnections(nets);
        List<BusConnectedCircuit.InputConnection> inputConnections = SchematicCircuitConverter.getInputConnections(nets);
        Map<NetReference, Integer> constantNets = SchematicCircuitConverter.getConstantNets(nets);
        CircuitBuilder builder = CircuitBuilder.builder();
        for (BusConnectedCircuit.InputConnection inputConnection : inputConnections) {
            for (NetReference netAtInput : inputConnection.connectedNets()) {
                builder.addInputNet(netAtInput, inputConnection.digitized() ? SignalType.DIGITAL : SignalType.ANALOG);
            }
        }
        for (Map.Entry entry : constantNets.entrySet()) {
            int value = (Integer)entry.getValue();
            SignalType type = value == 0 || value == 255 ? SignalType.DIGITAL : SignalType.ANALOG;
            builder.addInputNet((NetReference)entry.getKey(), type);
        }
        for (Map.Entry entry : nets.entrySet()) {
            Optional<ConnectedPin> source = SchematicCircuitConverter.getSource((Collection)entry.getValue());
            if (!source.isPresent() || source.get().pin().isCombinatorialOutput()) continue;
            builder.addDelayedNet((NetReference)entry.getKey(), source.get().pin().type());
        }
        Optional<List<PlacedSymbol>> order = SchematicCircuitConverter.getCellOrder(schematic.getSymbols(), SchematicCircuitConverter.getNetsBySource(nets.values()));
        if (order.isEmpty()) {
            return Optional.empty();
        }
        List<PlacedSymbol> list = order.get().stream().filter(s -> s.symbol().getType() instanceof CellSymbol).toList();
        for (PlacedSymbol cell : list) {
            SymbolInstance<?> instance = cell.symbol();
            CircuitBuilder.CellBuilder cellBuilder = builder.addCell(instance.makeCell(), cell.position());
            for (SymbolPin pin : instance.getPins()) {
                ConnectedPin connectedPin = new ConnectedPin(cell, pin);
                NetReference circuitNet = pinsToNet.get(connectedPin);
                if (pin.isOutput()) {
                    if (circuitNet == null) continue;
                    cellBuilder.output(pin.pinName(), circuitNet);
                    continue;
                }
                cellBuilder.input(pin.pinName(), circuitNet);
            }
            cellBuilder.buildCell();
        }
        return Optional.of(new BusConnectedCircuit(builder.build(), outputConnections, inputConnections, constantNets));
    }
}

