/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import malte0811.controlengineering.logic.schematic.ConnectedPin;
import malte0811.controlengineering.logic.schematic.SchematicChecker;
import malte0811.controlengineering.logic.schematic.WireSegment;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;

public class SchematicNet {
    public static final int WIRE_COLOR = -1005014;
    public static final int SELECTED_WIRE_COLOR = -984534;
    private static final MyCodec<List<WireSegment>> WIRE_LIST_CODEC = MyCodecs.list(WireSegment.CODEC);
    public static final MyCodec<SchematicNet> CODEC = new RecordCodec2<SchematicNet, List, List>(new CodecField<SchematicNet, List<WireSegment>>("horizontal", n -> n.horizontalSegments, WIRE_LIST_CODEC), new CodecField<SchematicNet, List<WireSegment>>("vertical", n -> n.verticalSegments, WIRE_LIST_CODEC), SchematicNet::new);
    private final List<WireSegment> horizontalSegments;
    private final List<WireSegment> verticalSegments;
    private final Iterable<WireSegment> allSegments;
    @Nullable
    private Set<ConnectedPin> pins;

    public SchematicNet() {
        this((List<WireSegment>)ImmutableList.of(), (List<WireSegment>)ImmutableList.of());
    }

    public SchematicNet(WireSegment singleWire) {
        this((List<WireSegment>)ImmutableList.of(), (List<WireSegment>)ImmutableList.of());
        this.addSegment(singleWire);
    }

    public SchematicNet(List<WireSegment> horizontal, List<WireSegment> vertical) {
        this.horizontalSegments = new ArrayList<WireSegment>(horizontal);
        this.verticalSegments = new ArrayList<WireSegment>(vertical);
        this.allSegments = () -> Iterators.concat(this.horizontalSegments.iterator(), this.verticalSegments.iterator());
    }

    public void addSegment(WireSegment segment) {
        if (segment.axis() == WireSegment.WireAxis.X) {
            this.horizontalSegments.add(segment);
        } else {
            this.verticalSegments.add(segment);
        }
        this.simplify();
    }

    public void addAll(SchematicNet other) {
        this.verticalSegments.addAll(other.verticalSegments);
        this.horizontalSegments.addAll(other.horizontalSegments);
        this.simplify();
    }

    public boolean contains(Vec2i point) {
        for (WireSegment s : this.allSegments) {
            if (!s.containsClosed(point)) continue;
            return true;
        }
        return false;
    }

    public void render(PoseStack stack, Vec2d mouse, List<PlacedSymbol> symbols) {
        int color = this.contains(mouse.floor()) ? -984534 : -1005014;
        for (WireSegment segment : this.allSegments) {
            segment.renderWithoutBlobs(stack, color);
        }
        Object2IntOpenHashMap endsAt = new Object2IntOpenHashMap();
        for (WireSegment segment : this.allSegments) {
            for (Vec2i end : segment.getEnds()) {
                if (endsAt.addTo((Object)end, 1) != 2) continue;
                GuiComponent.m_93172_((PoseStack)stack, (int)end.x(), (int)end.y(), (int)(end.x() + 1), (int)(end.y() + 1), (int)color);
            }
        }
        for (ConnectedPin pin : this.getOrComputePins(symbols)) {
            pin.render(stack, color);
        }
    }

    public Set<ConnectedPin> computeConnectedPins(List<PlacedSymbol> symbols) {
        HashSet<ConnectedPin> connected = new HashSet<ConnectedPin>();
        for (PlacedSymbol s : symbols) {
            for (SymbolPin output : s.symbol().getPins()) {
                if (!this.containsPin(s, output)) continue;
                connected.add(new ConnectedPin(s, output));
            }
        }
        return Collections.unmodifiableSet(connected);
    }

    public Set<ConnectedPin> getOrComputePins(List<PlacedSymbol> symbols) {
        if (this.pins == null) {
            this.pins = this.computeConnectedPins(symbols);
        }
        return this.pins;
    }

    public void resetCachedPins() {
        this.pins = null;
    }

    public Optional<Component> canMerge(SchematicNet other, List<PlacedSymbol> symbols) {
        HashSet<ConnectedPin> totalPins = new HashSet<ConnectedPin>(this.getOrComputePins(symbols));
        totalPins.addAll(other.getOrComputePins(symbols));
        return SchematicChecker.getConsistencyError(totalPins);
    }

    public boolean canAdd(WireSegment segment, List<PlacedSymbol> symbols) {
        return !this.canMerge(new SchematicNet(segment), symbols).isPresent();
    }

    private boolean containsPin(PlacedSymbol symbol, SymbolPin pin) {
        Vec2i actualPinPos = pin.position().add(symbol.position());
        return this.contains(actualPinPos);
    }

    public boolean removeOneContaining(Vec2i point) {
        Iterator<WireSegment> iterator = this.allSegments.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().containsClosed(point)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public List<SchematicNet> splitComponents() {
        HashMap<Object, SchematicNet> indexForPoint = new HashMap<Object, SchematicNet>();
        for (WireSegment segment : this.allSegments) {
            SchematicNet finalNet;
            SchematicNet first = (SchematicNet)indexForPoint.get(segment.start());
            SchematicNet second = (SchematicNet)indexForPoint.get(segment.end());
            if (first == null && second == null) {
                finalNet = new SchematicNet();
            } else if (first == null || second == null || first == second) {
                finalNet = first != null ? first : second;
            } else {
                finalNet = first;
                for (WireSegment segmentToMove : second.allSegments) {
                    first.addSegment(segmentToMove);
                    for (Vec2i end : segmentToMove.getEnds()) {
                        indexForPoint.put(end, finalNet);
                    }
                }
            }
            finalNet.addSegment(segment);
            for (Vec2i end : segment.getEnds()) {
                indexForPoint.put(end, finalNet);
            }
        }
        return indexForPoint.values().stream().distinct().collect(Collectors.toList());
    }

    public void simplify() {
        this.mergeIntervals();
        this.splitIntersections();
    }

    private void mergeIntervals() {
        SchematicNet.mergeIntervalsIn(WireSegment.WireAxis.X, this.horizontalSegments);
        SchematicNet.mergeIntervalsIn(WireSegment.WireAxis.Y, this.verticalSegments);
    }

    public Iterable<WireSegment> getAllSegments() {
        return this.allSegments;
    }

    private static void mergeIntervalsIn(WireSegment.WireAxis axis, List<WireSegment> segments) {
        segments.sort(Comparator.comparingInt(s -> axis.other().get(s.start())).thenComparing(s -> axis.get(s.start())));
        for (int i = 1; i < segments.size(); ++i) {
            int currentStart;
            int lastEnd;
            WireSegment current;
            WireSegment last = segments.get(i - 1);
            if (!last.isOnExtendedWire((current = segments.get(i)).start()) || (lastEnd = axis.get(last.end())) < (currentStart = axis.get(current.start()))) continue;
            int addedLength = Math.max(0, axis.get(current.end()) - lastEnd);
            segments.set(i - 1, new WireSegment(last.start(), last.length() + addedLength, axis));
            segments.remove(i);
            --i;
        }
    }

    private void splitIntersections() {
        block0: for (int xI = 0; xI < this.horizontalSegments.size(); ++xI) {
            WireSegment horizontal = this.horizontalSegments.get(xI);
            for (int yI = 0; yI < this.verticalSegments.size(); ++yI) {
                WireSegment vertical = this.verticalSegments.get(yI);
                if (!horizontal.crossesOneOpen(vertical)) continue;
                Vec2i intersection = new Vec2i(vertical.start().x(), horizontal.start().y());
                if (vertical.containsOpen(intersection)) {
                    this.verticalSegments.remove(yI);
                    --yI;
                    this.verticalSegments.addAll(vertical.splitAt(intersection));
                }
                if (!horizontal.containsOpen(intersection)) continue;
                this.horizontalSegments.remove(xI);
                --xI;
                this.horizontalSegments.addAll(horizontal.splitAt(intersection));
                continue block0;
            }
        }
    }
}

