/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import malte0811.controlengineering.util.ScreenUtils;
import malte0811.controlengineering.util.math.RectangleI;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec3;

public record WireSegment(Vec2i start, int length, WireAxis axis) {
    public static final MyCodec<WireSegment> CODEC = new RecordCodec3<WireSegment, Vec2i, Integer, WireAxis>(new CodecField<WireSegment, Vec2i>("start", WireSegment::start, Vec2i.CODEC), new CodecField<WireSegment, Integer>("length", WireSegment::length, MyCodecs.INTEGER), new CodecField<WireSegment, WireAxis>("axis", WireSegment::axis, WireAxis.CODEC), WireSegment::new);
    public static final float WIRE_SPACE = 0.125f;

    public Vec2i end() {
        return this.axis.addToCoord(this.start, this.length);
    }

    public boolean containsClosed(Vec2i point) {
        if (!this.isOnExtendedWire(point)) {
            return false;
        }
        return this.containsClosedOnAxis(this.axis.get(point));
    }

    public boolean containsOpen(Vec2i point) {
        if (!this.isOnExtendedWire(point)) {
            return false;
        }
        return this.containsOpenOnAxis(this.axis.get(point));
    }

    private boolean containsOpenOnAxis(int axisCoord) {
        int min = this.axis.get(this.start);
        return axisCoord > min && axisCoord < min + this.length;
    }

    private boolean containsClosedOnAxis(int axisCoord) {
        int min = this.axis.get(this.start);
        return axisCoord >= min && axisCoord <= min + this.length;
    }

    public boolean crossesOneOpen(WireSegment other) {
        if (this.axis() == other.axis()) {
            return false;
        }
        if (this.axis() == WireAxis.Y) {
            return other.crossesOneOpen(this);
        }
        int intersectionX = other.start().x();
        int intersectionY = this.start().y();
        if (!this.containsClosedOnAxis(intersectionX) || !other.containsClosedOnAxis(intersectionY)) {
            return false;
        }
        return this.containsOpenOnAxis(intersectionX) || other.containsOpenOnAxis(intersectionY);
    }

    public List<WireSegment> splitAt(Vec2i point) {
        Preconditions.checkArgument((boolean)this.containsOpen(point));
        int lengthFirst = this.axis.get(point) - this.axis.get(this.start);
        int lengthSecond = this.length - lengthFirst;
        return ImmutableList.of((Object)new WireSegment(this.start, lengthFirst, this.axis), (Object)new WireSegment(point, lengthSecond, this.axis));
    }

    public boolean isOnExtendedWire(Vec2i point) {
        return this.axis.other().get(point) == this.axis.other().get(this.start);
    }

    public Vec2i[] getEnds() {
        return new Vec2i[]{this.start(), this.end()};
    }

    public void renderWithoutBlobs(PoseStack stack, int color) {
        ScreenUtils.fill(stack, (float)this.start().x() + 0.125f, (float)this.start().y() + 0.125f, (float)(this.end().x() + 1) - 0.125f, (float)(this.end().y() + 1) - 0.125f, color);
    }

    public RectangleI getShape() {
        return new RectangleI(this.start(), this.end().add(1, 1));
    }

    public static enum WireAxis {
        X,
        Y;

        public static final MyCodec<WireAxis> CODEC;

        public Vec2i addToCoord(Vec2i fixed, int inAxisCoord) {
            if (this == X) {
                return new Vec2i(fixed.x() + inAxisCoord, fixed.y());
            }
            return new Vec2i(fixed.x(), fixed.y() + inAxisCoord);
        }

        public int get(Vec2i vec) {
            return this == X ? vec.x() : vec.y();
        }

        public <T> T get(T x, T y) {
            return this == X ? x : y;
        }

        public WireAxis other() {
            return this == X ? Y : X;
        }

        static {
            CODEC = MyCodecs.BOOL.xmap(b -> b != false ? X : Y, a -> a == X);
        }
    }
}

