/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicNet;
import malte0811.controlengineering.logic.schematic.client.ClientCellSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientConfigSwitch;
import malte0811.controlengineering.logic.schematic.client.ClientConstantSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientDividerSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientIOSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientInvAmpSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientOverlaySymbol;
import malte0811.controlengineering.logic.schematic.client.ClientSymbol;
import malte0811.controlengineering.logic.schematic.client.ClientTextSymbol;
import malte0811.controlengineering.logic.schematic.symbol.CellSymbol;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import malte0811.controlengineering.logic.schematic.symbol.SymbolInstance;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;

public class ClientSymbols {
    private static final Map<SchematicSymbol<?>, ClientSymbol<?, ?>> CLIENT_SYMBOLS = new HashMap();

    public static void init() {
        int secondColumn = 13;
        ClientSymbols.register(SchematicSymbols.CONSTANT, ClientConstantSymbol::new);
        ClientSymbols.registerWithOverlay(SchematicSymbols.INPUT_PIN_ANALOG, ClientIOSymbol::new, "A", 4.0f, 0.0f);
        ClientSymbols.registerWithOverlay(SchematicSymbols.INPUT_PIN_DIGITAL, ClientIOSymbol::new, "D", 4.0f, 0.0f);
        ClientSymbols.register(SchematicSymbols.OUTPUT_PIN, ClientIOSymbol::new);
        ClientSymbols.register(SchematicSymbols.AND2, 0, 0);
        ClientSymbols.register(SchematicSymbols.AND3, 0, 14);
        ClientSymbols.register(SchematicSymbols.OR2, 0, 7);
        ClientSymbols.register(SchematicSymbols.OR3, 0, 21);
        ClientSymbols.register(SchematicSymbols.NAND2, 13, 0);
        ClientSymbols.register(SchematicSymbols.NAND3, 13, 14);
        ClientSymbols.register(SchematicSymbols.NOR2, 13, 7);
        ClientSymbols.register(SchematicSymbols.NOR3, 13, 21);
        ClientSymbols.register(SchematicSymbols.XOR2, 0, 28);
        ClientSymbols.register(SchematicSymbols.XOR3, 0, 35);
        ClientSymbols.register(SchematicSymbols.NOT, 13, 28);
        ClientSymbols.register(SchematicSymbols.RS_LATCH, 13, 49);
        ClientSymbols.register(SchematicSymbols.SCHMITT_TRIGGER, 0, 42);
        ClientSymbols.register(SchematicSymbols.DIGITIZER, 13, 42);
        ClientSymbols.register(SchematicSymbols.COMPARATOR, 13, 35);
        ClientSymbols.register(SchematicSymbols.D_LATCH, 0, 49);
        ClientSymbols.register(SchematicSymbols.DELAY_LINE, 0, 56);
        ClientSymbols.registerMUX(SchematicSymbols.ANALOG_MUX, "A");
        ClientSymbols.registerMUX(SchematicSymbols.DIGITAL_MUX, "D");
        ClientSymbols.register(SchematicSymbols.VOLTAGE_DIVIDER, ClientDividerSymbol::new);
        ClientSymbols.register(SchematicSymbols.ANALOG_ADDER, 24, 11);
        ClientSymbols.register(SchematicSymbols.INVERTING_AMPLIFIER, ClientInvAmpSymbol::new);
        ClientSymbols.register(SchematicSymbols.TEXT, ClientTextSymbol::new);
        ClientSymbols.register(SchematicSymbols.CONFIG_SWITCH, ClientConfigSwitch::new);
    }

    public static <State> void renderCenteredInBox(SymbolInstance<State> inst, PoseStack transform, int x, int y, int xSpace, int ySpace) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        SchematicSymbol type = (SchematicSymbol)inst.getType();
        int width = type.getXSize(inst.getCurrentState(), (Level)level);
        int height = type.getYSize(inst.getCurrentState(), (Level)level);
        float scale = Math.max(1.0f, Math.min((float)width / (float)xSpace, (float)height / (float)ySpace));
        transform.m_85836_();
        transform.m_85837_((double)x + (double)xSpace / 2.0, (double)y + (double)ySpace / 2.0, 0.0);
        transform.m_85841_(scale, scale, 1.0f);
        transform.m_85837_((double)(-width) / 2.0, (double)(-height) / 2.0, 0.0);
        ClientSymbols.render(inst, transform, 0, 0);
        transform.m_85849_();
    }

    public static <State> void render(SymbolInstance<State> inst, PoseStack transform, int x, int y) {
        ClientSymbols.render((SchematicSymbol)inst.getType(), transform, x, y, inst.getCurrentState());
    }

    public static <State> void render(SchematicSymbol<State> serverSymbol, PoseStack transform, int x, int y, State state) {
        ClientSymbols.getClientSymbol(serverSymbol).render(transform, x, y, state);
    }

    public static void render(PlacedSymbol placed, PoseStack transform) {
        ClientSymbols.render(placed.symbol(), transform, placed.position().x(), placed.position().y());
    }

    public static void render(Schematic schematic, PoseStack stack, Vec2d mouse) {
        for (PlacedSymbol s : schematic.getSymbols()) {
            ClientSymbols.render(s, stack);
        }
        for (SchematicNet net : schematic.getNets()) {
            net.render(stack, mouse, schematic.getSymbols());
        }
    }

    public static <State> void createInstanceWithUI(SchematicSymbol<State> symbol, Consumer<? super SymbolInstance<State>> onDone, State initialState) {
        ClientSymbols.getClientSymbol(symbol).createInstanceWithUI(onDone, initialState);
    }

    public static <State> void createInstanceWithUI(SchematicSymbol<State> symbol, Consumer<? super SymbolInstance<State>> onDone) {
        ClientSymbols.createInstanceWithUI(symbol, onDone, symbol.getInitialState());
    }

    private static <State, Symbol extends SchematicSymbol<State>> ClientSymbol<State, Symbol> getClientSymbol(Symbol server) {
        return CLIENT_SYMBOLS.get(server);
    }

    private static void register(CellSymbol cell, int uMin, int vMin) {
        ClientSymbols.register(cell, new ClientCellSymbol(cell, uMin, vMin));
    }

    private static void registerMUX(CellSymbol cell, String overlay) {
        ClientSymbols.register(cell, new ClientOverlaySymbol(new ClientCellSymbol(cell, 13, 56), overlay, 3.0f, 3.0f));
    }

    private static <State, Symbol extends SchematicSymbol<State>> void register(Symbol server, Function<Symbol, ClientSymbol<State, Symbol>> makeClient) {
        ClientSymbols.register(server, makeClient.apply(server));
    }

    private static <State, Symbol extends SchematicSymbol<State>> void registerWithOverlay(Symbol server, Function<Symbol, ClientSymbol<State, Symbol>> makeClient, String overlay, float xOff, float yOff) {
        ClientSymbols.register(server, new ClientOverlaySymbol<State, Symbol>(makeClient.apply(server), overlay, xOff, yOff));
    }

    private static <State, Symbol extends SchematicSymbol<State>> void register(Symbol server, ClientSymbol<State, Symbol> client) {
        CLIENT_SYMBOLS.put(server, client);
    }
}

