/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic.symbol;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;

public class CellSymbol<Config>
extends SchematicSymbol<Config> {
    private final LeafcellType<?, Config> type;
    private final int width;
    private final int height;
    private final List<SymbolPin> pins;

    public CellSymbol(LeafcellType<?, Config> type, int width, int height, List<SymbolPin> pins) {
        super(((Pair)type.getInitialState()).getSecond(), type.getConfigCodec());
        this.type = type;
        this.width = width;
        this.height = height;
        this.pins = pins;
        for (SymbolPin pin : pins) {
            if (pin.isOutput()) {
                Preconditions.checkState((boolean)type.getOutputPins().containsKey(pin.pinName()));
                continue;
            }
            Preconditions.checkState((boolean)type.getInputPins().containsKey(pin.pinName()));
        }
    }

    @Override
    public int getXSize(Config state, @Nonnull Level level) {
        return this.width;
    }

    @Override
    public int getYSize(Config state, @Nonnull Level level) {
        return this.height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public List<SymbolPin> getPins(@Nullable Config unit) {
        return this.pins;
    }

    public static String getTranslationKey(LeafcellType<?, ?> type) {
        return "cell." + type.getRegistryName().m_135827_() + "." + type.getRegistryName().m_135815_() + ".name";
    }

    @Override
    public Component getDefaultName() {
        return new TranslatableComponent(CellSymbol.getTranslationKey(this.type));
    }

    public LeafcellType<?, Config> getCellType() {
        return this.type;
    }

    @Override
    public CellCost getCost() {
        return this.type.getCost();
    }

    public String toString() {
        return "[Cell:" + this.getCellType() + "]";
    }
}

