/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic.symbol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class IOSymbol
extends SchematicSymbol<BusSignalRef> {
    public static final String ANALOG_INPUT_KEY = "controlengineering.symbol.inputPinAnalog";
    public static final String DIGITAL_INPUT_KEY = "controlengineering.symbol.inputPinDigital";
    public static final String OUTPUT_KEY = "controlengineering.symbol.outputPin";
    public static final String SIGNAL_KEY = "controlengineering.gui.busRef";
    public static final String VANILLA_COLOR_PREFIX = "item.minecraft.firework_star.";
    private static final List<SymbolPin> OUTPUT_PIN_A = ImmutableList.of((Object)SymbolPin.analogOut(5, 1, "out"));
    private static final List<SymbolPin> OUTPUT_PIN_D = ImmutableList.of((Object)SymbolPin.digitalOut(5, 1, "out"));
    private static final List<SymbolPin> INPUT_PIN = ImmutableList.of((Object)SymbolPin.analogIn(0, 1, "in"));
    private final boolean isInput;
    private final boolean isDigitized;

    public IOSymbol(boolean isInput, boolean isDigitized) {
        super(BusSignalRef.DEFAULT, BusSignalRef.CODEC);
        Preconditions.checkArgument((isInput || !isDigitized ? 1 : 0) != 0);
        this.isInput = isInput;
        this.isDigitized = isDigitized;
    }

    @Override
    public int getXSize(BusSignalRef state, @Nonnull Level level) {
        return 6;
    }

    @Override
    public int getYSize(BusSignalRef state, @Nonnull Level level) {
        return 3;
    }

    @Override
    public List<SymbolPin> getPins(@Nullable BusSignalRef state) {
        if (!this.isInput) {
            return INPUT_PIN;
        }
        if (this.isDigitized) {
            return OUTPUT_PIN_D;
        }
        return OUTPUT_PIN_A;
    }

    @Override
    public Component getDefaultName() {
        return new TranslatableComponent(!this.isInput ? OUTPUT_KEY : (this.isDigitized ? DIGITAL_INPUT_KEY : ANALOG_INPUT_KEY));
    }

    @Override
    public List<MutableComponent> getExtraDescription(BusSignalRef state) {
        DyeColor color = DyeColor.m_41053_((int)state.color());
        String colorName = I18n.m_118938_((String)(VANILLA_COLOR_PREFIX + color), (Object[])new Object[0]);
        return ImmutableList.of((Object)new TranslatableComponent(SIGNAL_KEY, new Object[]{colorName, state.line()}));
    }

    @Override
    public CellCost getCost() {
        if (this.isDigitized) {
            return SchematicSymbols.DIGITIZER.getCost();
        }
        return super.getCost();
    }

    public boolean isInput() {
        return this.isInput;
    }
}

