/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic.symbol;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.List;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.cells.Leafcells;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.schematic.symbol.CellSymbol;
import malte0811.controlengineering.logic.schematic.symbol.ConfigSwitchSymbol;
import malte0811.controlengineering.logic.schematic.symbol.ConstantSymbol;
import malte0811.controlengineering.logic.schematic.symbol.IOSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import malte0811.controlengineering.logic.schematic.symbol.TextSymbol;
import malte0811.controlengineering.util.math.Fraction;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.typereg.TypedRegistry;
import net.minecraft.resources.ResourceLocation;

public class SchematicSymbols {
    public static final TypedRegistry<SchematicSymbol<?>> REGISTRY = new TypedRegistry();
    public static final ResourceLocation SYMBOLS_SHEET = new ResourceLocation("controlengineering", "textures/gui/schematic_symbols.png");
    public static final IOSymbol INPUT_PIN_ANALOG = new IOSymbol(true, false);
    public static final IOSymbol INPUT_PIN_DIGITAL = new IOSymbol(true, true);
    public static final IOSymbol OUTPUT_PIN = new IOSymbol(false, false);
    public static final ConstantSymbol CONSTANT = new ConstantSymbol();
    public static final CellSymbol<Unit> NOT;
    public static final CellSymbol<Unit> AND2;
    public static final CellSymbol<Unit> AND3;
    public static final CellSymbol<Unit> OR2;
    public static final CellSymbol<Unit> OR3;
    public static final CellSymbol<Unit> NAND2;
    public static final CellSymbol<Unit> NAND3;
    public static final CellSymbol<Unit> NOR2;
    public static final CellSymbol<Unit> NOR3;
    public static final CellSymbol<Unit> XOR2;
    public static final CellSymbol<Unit> XOR3;
    public static final CellSymbol<Unit> RS_LATCH;
    public static final CellSymbol<Unit> SCHMITT_TRIGGER;
    public static final CellSymbol<Unit> DELAY_LINE;
    public static final CellSymbol<Unit> D_LATCH;
    public static final CellSymbol<Unit> DIGITIZER;
    public static final CellSymbol<Unit> COMPARATOR;
    public static final CellSymbol<Unit> ANALOG_MUX;
    public static final CellSymbol<Unit> DIGITAL_MUX;
    public static final CellSymbol<Integer> VOLTAGE_DIVIDER;
    public static final CellSymbol<Unit> ANALOG_ADDER;
    public static final CellSymbol<Fraction> INVERTING_AMPLIFIER;
    public static final CellSymbol<Boolean> CONFIG_SWITCH;
    public static final TextSymbol TEXT;

    private static CellSymbol<Unit> delayCell(LeafcellType<?, Unit> cell, int uSize, SignalType type) {
        ImmutableList pins = ImmutableList.of((Object)new SymbolPin(0, 3, type, PinDirection.INPUT, "in"), (Object)new SymbolPin(uSize - 1, 3, type, PinDirection.DELAYED_OUTPUT, "out"));
        return SchematicSymbols.registerCell(cell, uSize, (List<SymbolPin>)pins);
    }

    private static CellSymbol<Unit> registerMUX(LeafcellType<?, Unit> cell, SignalType type) {
        return SchematicSymbols.registerCell(cell, 7, 8, List.of(new SymbolPin(0, 1, type, PinDirection.INPUT, "in0"), new SymbolPin(0, 5, type, PinDirection.INPUT, "in1"), new SymbolPin(new Vec2i(4, 7), SignalType.DIGITAL, PinDirection.INPUT, "select", true), new SymbolPin(6, 3, type, PinDirection.OUTPUT, "out")));
    }

    private static <C> CellSymbol<C> registerSimpleCell(LeafcellType<?, C> cell, int uSize, List<SymbolPin> inputPins) {
        ArrayList<SymbolPin> allPins = new ArrayList<SymbolPin>(inputPins);
        allPins.add(SymbolPin.digitalOut(uSize - 1, 3, "out"));
        return SchematicSymbols.registerCell(cell, uSize, allPins);
    }

    private static <C> CellSymbol<C> registerCell(LeafcellType<?, C> cell, int uSize, List<SymbolPin> pins) {
        return SchematicSymbols.registerCell(cell, uSize, 7, pins);
    }

    private static <C> CellSymbol<C> registerCell(LeafcellType<?, C> cell, int uSize, int vSize, List<SymbolPin> pins) {
        return SchematicSymbols.registerCell(new CellSymbol<C>(cell, uSize, vSize, pins));
    }

    private static <C> CellSymbol<C> registerCell(CellSymbol<C> symbol) {
        return REGISTRY.register(symbol.getCellType().getRegistryName(), symbol);
    }

    static {
        TEXT = new TextSymbol();
        ImmutableList twoInputPins = ImmutableList.of((Object)SymbolPin.digitalIn(0, 1, "in1"), (Object)SymbolPin.digitalIn(0, 5, "in2"));
        ImmutableList threeInputPinsFlush = ImmutableList.of((Object)SymbolPin.digitalIn(0, 1, "in1"), (Object)SymbolPin.digitalIn(0, 3, "in2"), (Object)SymbolPin.digitalIn(0, 5, "in3"));
        ImmutableList threeInputPinsShift = ImmutableList.of((Object)SymbolPin.digitalIn(0, 1, "in1"), (Object)SymbolPin.digitalIn(1, 3, "in2"), (Object)SymbolPin.digitalIn(0, 5, "in3"));
        AND2 = SchematicSymbols.registerSimpleCell(Leafcells.AND2, 9, (List<SymbolPin>)twoInputPins);
        AND3 = SchematicSymbols.registerSimpleCell(Leafcells.AND3, 9, (List<SymbolPin>)threeInputPinsFlush);
        OR2 = SchematicSymbols.registerSimpleCell(Leafcells.OR2, 11, (List<SymbolPin>)twoInputPins);
        OR3 = SchematicSymbols.registerSimpleCell(Leafcells.OR3, 11, (List<SymbolPin>)threeInputPinsShift);
        NAND2 = SchematicSymbols.registerSimpleCell(Leafcells.NAND2, 12, (List<SymbolPin>)twoInputPins);
        NAND3 = SchematicSymbols.registerSimpleCell(Leafcells.NAND3, 12, (List<SymbolPin>)threeInputPinsFlush);
        NOR2 = SchematicSymbols.registerSimpleCell(Leafcells.NOR2, 13, (List<SymbolPin>)twoInputPins);
        NOR3 = SchematicSymbols.registerSimpleCell(Leafcells.NOR3, 13, (List<SymbolPin>)threeInputPinsShift);
        XOR2 = SchematicSymbols.registerSimpleCell(Leafcells.XOR2, 13, (List<SymbolPin>)twoInputPins);
        XOR3 = SchematicSymbols.registerSimpleCell(Leafcells.XOR3, 13, (List<SymbolPin>)threeInputPinsShift);
        NOT = SchematicSymbols.registerSimpleCell(Leafcells.NOT, 13, (List<SymbolPin>)ImmutableList.of((Object)SymbolPin.digitalIn(0, 3, "in")));
        RS_LATCH = SchematicSymbols.registerCell(Leafcells.RS_LATCH, 13, (List<SymbolPin>)ImmutableList.of((Object)SymbolPin.digitalIn(0, 1, "set"), (Object)SymbolPin.digitalIn(0, 5, "reset"), (Object)new SymbolPin(12, 1, SignalType.DIGITAL, PinDirection.DELAYED_OUTPUT, "q"), (Object)new SymbolPin(12, 5, SignalType.DIGITAL, PinDirection.DELAYED_OUTPUT, "not_q")));
        SCHMITT_TRIGGER = SchematicSymbols.registerSimpleCell(Leafcells.SCHMITT_TRIGGER, 13, (List<SymbolPin>)ImmutableList.of((Object)SymbolPin.analogIn(0, 1, "high"), (Object)SymbolPin.analogIn(0, 3, "in"), (Object)SymbolPin.analogIn(0, 5, "low")));
        DIGITIZER = SchematicSymbols.registerSimpleCell(Leafcells.DIGITIZER, 13, (List<SymbolPin>)ImmutableList.of((Object)SymbolPin.analogIn(0, 3, "in")));
        COMPARATOR = SchematicSymbols.registerSimpleCell(Leafcells.COMPARATOR, 13, (List<SymbolPin>)ImmutableList.of((Object)SymbolPin.analogIn(0, 1, "negative"), (Object)SymbolPin.analogIn(0, 5, "positive")));
        D_LATCH = SchematicSymbols.delayCell(Leafcells.D_LATCH, 10, SignalType.DIGITAL);
        DELAY_LINE = SchematicSymbols.delayCell(Leafcells.DELAY_LINE, 13, SignalType.ANALOG);
        ANALOG_MUX = SchematicSymbols.registerMUX(Leafcells.ANALOG_MUX, SignalType.ANALOG);
        DIGITAL_MUX = SchematicSymbols.registerMUX(Leafcells.DIGITAL_MUX, SignalType.DIGITAL);
        VOLTAGE_DIVIDER = SchematicSymbols.registerCell(Leafcells.DIVIDER, 8, 11, List.of(SymbolPin.analogIn(0, 0, "input_a"), SymbolPin.analogIn(0, 10, "input_b"), SymbolPin.analogOut(7, 5, "out")));
        ANALOG_ADDER = SchematicSymbols.registerCell(Leafcells.ANALOG_ADDER, 9, List.of(SymbolPin.analogIn(0, 0, "in_a"), SymbolPin.analogIn(0, 6, "in_b"), SymbolPin.analogOut(7, 3, "out")));
        INVERTING_AMPLIFIER = SchematicSymbols.registerCell(Leafcells.INVERTING_AMPLIFIER, 13, List.of(SymbolPin.analogIn(0, 3, "in"), SymbolPin.analogOut(12, 3, "out")));
        CONFIG_SWITCH = SchematicSymbols.registerCell(new ConfigSwitchSymbol());
        REGISTRY.register(new ResourceLocation("controlengineering", "input_pin"), INPUT_PIN_ANALOG);
        REGISTRY.register(new ResourceLocation("controlengineering", "input_pin_digitized"), INPUT_PIN_DIGITAL);
        REGISTRY.register(new ResourceLocation("controlengineering", "output_pin"), OUTPUT_PIN);
        REGISTRY.register(new ResourceLocation("controlengineering", "constant"), CONSTANT);
        REGISTRY.register(new ResourceLocation("controlengineering", "text"), TEXT);
    }
}

