/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.logic.schematic.symbol;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import malte0811.controlengineering.logic.cells.PinDirection;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.util.ScreenUtils;
import malte0811.controlengineering.util.math.Vec2i;

public record SymbolPin(Vec2i position, SignalType type, PinDirection direction, String pinName, boolean vertical) {
    public SymbolPin(Vec2i position, SignalType type, PinDirection direction, String pinName) {
        this(position, type, direction, pinName, false);
    }

    public SymbolPin(int x, int y, SignalType type, PinDirection direction, String pinName) {
        this(new Vec2i(x, y), type, direction, pinName);
    }

    public static SymbolPin digitalOut(int x, int y, String name) {
        return new SymbolPin(x, y, SignalType.DIGITAL, PinDirection.OUTPUT, name);
    }

    public static SymbolPin analogOut(int x, int y, String name) {
        return new SymbolPin(x, y, SignalType.ANALOG, PinDirection.OUTPUT, name);
    }

    public static SymbolPin analogIn(int x, int y, String name) {
        return new SymbolPin(x, y, SignalType.ANALOG, PinDirection.INPUT, name);
    }

    public static SymbolPin digitalIn(int x, int y, String name) {
        return new SymbolPin(x, y, SignalType.DIGITAL, PinDirection.INPUT, name);
    }

    public boolean isOutput() {
        return this.direction.isOutput();
    }

    public boolean isCombinatorialOutput() {
        return this.direction.isCombinatorialOutput();
    }

    public void render(PoseStack stack, int x, int y, int wireColor) {
        Vec2i pinPos = this.position().add(x, y);
        if (this.vertical) {
            stack.m_85836_();
            stack.m_85837_((double)pinPos.x() + 0.5, (double)pinPos.y() + 0.5, 0.0);
            stack.m_85845_(new Quaternion(0.0f, 0.0f, -1.5707964f, false));
            stack.m_85837_(-0.5 - (double)pinPos.x(), -0.5 - (double)pinPos.y(), 0.0);
        }
        boolean wirePixels = true;
        float wireXMin = (float)pinPos.x() + (this.isOutput() ? -1.0f : 0.125f);
        float wireXMax = (float)pinPos.x() + (this.isOutput() ? 0.875f : 2.0f);
        float yMin = (float)pinPos.y() + 0.125f;
        float yMax = (float)(pinPos.y() + 1) - 0.125f;
        ScreenUtils.fill(stack, wireXMin, yMin, wireXMax, yMax, wireColor);
        int color = this.isOutput() ? -65536 : -16711936;
        ScreenUtils.fill(stack, (float)pinPos.x() + 0.125f, yMin, (float)(pinPos.x() + 1) - 0.125f, yMax, color);
        if (this.vertical) {
            stack.m_85849_();
        }
    }
}

