/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.Objects;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.util.ItemUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkEvent;

public class CutTapePacket
extends SimplePacket {
    private final InteractionHand hand;
    private final int offset;

    public CutTapePacket(InteractionHand hand, int offset) {
        this.hand = hand;
        this.offset = offset;
    }

    public CutTapePacket(FriendlyByteBuf in) {
        this(in.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, in.m_130242_());
    }

    @Override
    public void write(FriendlyByteBuf out) {
        out.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        out.m_130130_(this.offset);
    }

    @Override
    protected void processOnThread(NetworkEvent.Context ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.getSender());
        if (!CutTapePacket.canCut(this.hand, (Player)player)) {
            return;
        }
        byte[] data = PunchedTapeItem.getBytes(player.m_21120_(this.hand));
        if (this.offset < 0 || this.offset >= data.length) {
            return;
        }
        byte[] startData = new byte[this.offset];
        byte[] endData = new byte[data.length - this.offset - 1];
        System.arraycopy(data, 0, startData, 0, this.offset);
        System.arraycopy(data, this.offset + 1, endData, 0, endData.length);
        player.m_21008_(this.hand, ItemStack.f_41583_);
        player.m_21120_(CutTapePacket.otherHand(this.hand)).m_41629_(1, ApiUtils.RANDOM, player);
        this.giveTape((Player)player, startData);
        this.giveTape((Player)player, endData);
    }

    private void giveTape(Player player, byte[] data) {
        if (data.length > 0) {
            ItemUtil.giveOrDrop(player, PunchedTapeItem.withBytes(data));
        }
    }

    private static InteractionHand otherHand(InteractionHand in) {
        return in == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static boolean canCut(InteractionHand tapeHand, Player player) {
        if (player.m_21120_(tapeHand).m_41720_() != CEItems.PUNCHED_TAPE.get()) {
            return false;
        }
        ItemStack shears = player.m_21120_(CutTapePacket.otherHand(tapeHand));
        return shears.m_204117_(Tags.Items.SHEARS);
    }
}

