/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.keypunch;

import com.google.common.base.Preconditions;
import malte0811.controlengineering.gui.tape.KeypunchMenu;
import malte0811.controlengineering.gui.tape.KeypunchScreen;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.keypunch.KeypunchSubPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class KeypunchPacket
extends SimplePacket {
    private final KeypunchSubPacket packet;

    public KeypunchPacket(FriendlyByteBuf buffer) {
        this(KeypunchSubPacket.read(buffer));
    }

    public KeypunchPacket(KeypunchSubPacket data) {
        this.packet = data;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        this.packet.writeFull(out);
    }

    @Override
    protected void processOnThread(NetworkEvent.Context ctx) {
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            Preconditions.checkState((boolean)this.packet.allowSendingToServer());
            AbstractContainerMenu abstractContainerMenu = ctx.getSender().f_36096_;
            if (abstractContainerMenu instanceof KeypunchMenu) {
                KeypunchMenu keypunch = (KeypunchMenu)abstractContainerMenu;
                if (keypunch.isLoopback()) {
                    this.packet.process(keypunch.getState());
                    keypunch.sendToListeningPlayersExcept(ctx.getSender(), this.packet);
                    keypunch.markDirty();
                } else {
                    this.packet.process(keypunch.getPrintNonLoopback());
                }
            }
        } else {
            this.processOnClient();
        }
    }

    private void processOnClient() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof KeypunchScreen) {
            KeypunchScreen punchScreen = (KeypunchScreen)screen;
            this.packet.process(punchScreen.getState());
            punchScreen.updateData();
        }
    }
}

