/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.keypunch;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import malte0811.controlengineering.blockentity.tape.KeypunchState;
import malte0811.controlengineering.network.keypunch.Backspace;
import malte0811.controlengineering.network.keypunch.FullSync;
import malte0811.controlengineering.network.keypunch.TypeChar;
import net.minecraft.network.FriendlyByteBuf;

public abstract class KeypunchSubPacket {
    static final List<Function<FriendlyByteBuf, ? extends KeypunchSubPacket>> FROM_BYTES = new ArrayList<Function<FriendlyByteBuf, ? extends KeypunchSubPacket>>();
    static final Object2IntMap<Class<? extends KeypunchSubPacket>> BY_TYPE = new Object2IntOpenHashMap();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        KeypunchSubPacket.register(FullSync.class, FullSync::new);
        KeypunchSubPacket.register(TypeChar.class, TypeChar::new);
        KeypunchSubPacket.register(Backspace.class, Backspace::new);
        initialized = true;
    }

    private static <T extends KeypunchSubPacket> void register(Class<T> type, Function<FriendlyByteBuf, T> construct) {
        BY_TYPE.put(type, FROM_BYTES.size());
        FROM_BYTES.add(construct);
    }

    protected static KeypunchSubPacket read(FriendlyByteBuf buffer) {
        KeypunchSubPacket.init();
        return FROM_BYTES.get(buffer.m_130242_()).apply(buffer);
    }

    public final void writeFull(FriendlyByteBuf buffer) {
        KeypunchSubPacket.init();
        buffer.m_130130_(BY_TYPE.getInt(this.getClass()));
        this.write(buffer);
    }

    protected abstract void write(FriendlyByteBuf var1);

    public abstract boolean process(KeypunchState var1);

    public void process(ByteConsumer remotePrint) {
    }

    public boolean allowSendingToServer() {
        return true;
    }
}

