/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.logic;

import com.google.common.base.Preconditions;
import malte0811.controlengineering.client.ClientHooks;
import malte0811.controlengineering.gui.logic.LogicDesignMenu;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.logic.LogicSubPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class LogicPacket
extends SimplePacket {
    private final LogicSubPacket packet;

    public LogicPacket(FriendlyByteBuf buffer) {
        this(LogicSubPacket.read(buffer));
    }

    public LogicPacket(LogicSubPacket data) {
        this.packet = data;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        this.packet.writeFull(out);
    }

    @Override
    protected void processOnThread(NetworkEvent.Context ctx) {
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            Preconditions.checkState((boolean)this.packet.allowSendingToServer());
            AbstractContainerMenu activeContainer = ctx.getSender().f_36096_;
            if (!(activeContainer instanceof LogicDesignMenu)) {
                return;
            }
            LogicDesignMenu logicMenu = (LogicDesignMenu)activeContainer;
            if (!logicMenu.readOnly || this.packet.canApplyOnReadOnly()) {
                this.packet.process(logicMenu.getSchematic(), $ -> {
                    throw new RuntimeException();
                }, ctx.getSender().f_19853_);
                logicMenu.sendToListeningPlayersExcept(ctx.getSender(), this.packet);
                logicMenu.markDirty();
            }
        } else {
            ClientHooks.processLogicPacketOnClient(this.packet);
        }
    }
}

