/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.logic;

import java.util.List;
import java.util.function.Consumer;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.network.logic.LogicSubPacket;
import malte0811.controlengineering.util.mycodec.serial.PacketBufferStorage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class ModifySymbol
extends LogicSubPacket {
    private final PlacedSymbol newSymbol;

    public ModifySymbol(PlacedSymbol newSymbol) {
        this.newSymbol = newSymbol;
    }

    public ModifySymbol(FriendlyByteBuf in) {
        this(PlacedSymbol.CODEC.from(in));
    }

    @Override
    protected void write(FriendlyByteBuf out) {
        PlacedSymbol.CODEC.toSerial(new PacketBufferStorage(out), this.newSymbol);
    }

    @Override
    public boolean process(Schematic applyTo, Consumer<Schematic> replace, Level level) {
        List<PlacedSymbol> symbols = applyTo.getSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            PlacedSymbol oldSymbol = symbols.get(i);
            if (oldSymbol.symbol().getType() != this.newSymbol.symbol().getType() || !oldSymbol.position().equals(this.newSymbol.position())) continue;
            return applyTo.replaceBy(i, this.newSymbol, level);
        }
        return false;
    }

    @Override
    public boolean canApplyOnReadOnly() {
        return ((SchematicSymbol)this.newSymbol.symbol().getType()).canConfigureOnReadOnly();
    }
}

