/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.panellayout;

import com.google.common.base.Preconditions;
import malte0811.controlengineering.client.ClientHooks;
import malte0811.controlengineering.gui.panel.PanelDesignMenu;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.panellayout.PanelSubPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PanelPacket
extends SimplePacket {
    private final PanelSubPacket packet;

    public PanelPacket(FriendlyByteBuf buffer) {
        this(PanelSubPacket.read(buffer));
    }

    public PanelPacket(PanelSubPacket data) {
        this.packet = data;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        this.packet.writeFull(out);
    }

    @Override
    protected void processOnThread(NetworkEvent.Context ctx) {
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            Preconditions.checkState((boolean)this.packet.allowSendingToServer());
            AbstractContainerMenu activeContainer = ctx.getSender().f_36096_;
            if (activeContainer instanceof PanelDesignMenu) {
                PanelDesignMenu panelContainer = (PanelDesignMenu)activeContainer;
                this.packet.process(ctx.getSender().f_19853_, panelContainer.getComponents());
                panelContainer.sendToListeningPlayersExcept(ctx.getSender(), this.packet);
                panelContainer.markDirty();
            }
        } else {
            ClientHooks.processPanelPacketOnClient(this.packet);
        }
    }
}

