/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.panellayout;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.network.panellayout.PanelSubPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class Replace
extends PanelSubPacket {
    @Nullable
    private final PlacedComponent newComponent;

    public Replace(@Nullable PlacedComponent newComponent) {
        this.newComponent = newComponent;
    }

    public Replace(FriendlyByteBuf buffer) {
        this(PlacedComponent.readWithoutState(buffer));
    }

    @Override
    protected void write(FriendlyByteBuf out) {
        ((PlacedComponent)Preconditions.checkNotNull((Object)this.newComponent)).writeToWithoutState(out);
    }

    @Override
    public boolean process(Level level, List<PlacedComponent> allComponents) {
        if (this.newComponent == null || !this.newComponent.isWithinPanel(level)) {
            return false;
        }
        int toReplace = -1;
        for (int i = 0; i < allComponents.size(); ++i) {
            PlacedComponent existing = allComponents.get(i);
            if (existing.getPosMin().equals(this.newComponent.getPosMin())) {
                toReplace = i;
                continue;
            }
            if (existing.disjoint(level, this.newComponent)) continue;
            return false;
        }
        if (toReplace < 0) {
            return false;
        }
        allComponents.set(toReplace, this.newComponent);
        return true;
    }
}

