/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.network.remapper;

import com.google.common.base.Preconditions;
import malte0811.controlengineering.gui.remapper.RSRemapperMenu;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.remapper.RSRemapperSubPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RSRemapperPacket
extends SimplePacket {
    private final RSRemapperSubPacket packet;

    public RSRemapperPacket(FriendlyByteBuf buffer) {
        this(RSRemapperSubPacket.read(buffer));
    }

    public RSRemapperPacket(RSRemapperSubPacket data) {
        this.packet = data;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        this.packet.writeFull(out);
    }

    @Override
    protected void processOnThread(NetworkEvent.Context ctx) {
        AbstractContainerMenu abstractMenu;
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            Preconditions.checkState((boolean)this.packet.allowSendingToServer());
            abstractMenu = ctx.getSender().f_36096_;
        } else {
            abstractMenu = Minecraft.m_91087_().f_91074_.f_36096_;
        }
        if (abstractMenu instanceof RSRemapperMenu) {
            RSRemapperMenu menu = (RSRemapperMenu)abstractMenu;
            this.updateConnections(menu);
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                menu.sendToListeningPlayersExcept(ctx.getSender(), this.packet);
            }
            menu.markDirty();
        }
    }

    public void updateConnections(RSRemapperMenu menu) {
        int[] newCToG = this.packet.process(menu.getColorToGray());
        menu.setColorToGray(newCToG);
    }
}

