/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util;

import com.google.common.base.Preconditions;

public class BitUtils {
    public static int getBits(int value, int offset, int bits) {
        int mask = (1 << bits) - 1;
        return value >>> offset & mask;
    }

    public static boolean getBit(int value, int bit) {
        return BitUtils.getBits(value, bit, 1) != 0;
    }

    public static boolean calculateParityBit(byte data) {
        return BitUtils.getSetBits(data & 0x7F) % 2 == 1;
    }

    public static boolean noBitsAbove(int value, int maxAllowedBit) {
        return value >>> maxAllowedBit + 1 == 0;
    }

    public static boolean isCorrectParity(byte data) {
        return BitUtils.getBit(data, 7) == BitUtils.calculateParityBit(data);
    }

    public static int getSetBits(int v) {
        int count = 0;
        while (v != 0) {
            v &= v - 1;
            ++count;
        }
        return count;
    }

    public static byte[] toBytesWithParity(String in) {
        for (int i = 0; i < in.length(); ++i) {
            Preconditions.checkArgument((boolean)BitUtils.isASCIICharacter(in.codePointAt(i)));
        }
        byte[] result = in.getBytes();
        for (int i = 0; i < result.length; ++i) {
            result[i] = BitUtils.fixParity(result[i]);
        }
        return result;
    }

    public static byte clearParity(byte withParity) {
        return (byte)(withParity & 0x7F);
    }

    public static byte fixParity(byte in) {
        if (BitUtils.calculateParityBit(in)) {
            return (byte)(in | 0x80);
        }
        return BitUtils.clearParity(in);
    }

    public static boolean isASCIICharacter(int in) {
        return BitUtils.noBitsAbove(in, 6);
    }

    public static String toString(byte[] withParity) {
        byte[] copyWithoutParity = new byte[withParity.length];
        for (int i = 0; i < withParity.length; ++i) {
            if ((withParity[i] & 0xFF) == 255) continue;
            copyWithoutParity[i] = BitUtils.clearParity(withParity[i]);
        }
        return new String(copyWithoutParity);
    }
}

