/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;

public class CachedValue<Key, Value>
implements Supplier<Value> {
    private final Supplier<Key> getKey;
    private final Function<Key, Value> create;
    private final BiPredicate<Key, Key> equivalent;
    private final Function<Key, Key> copy;
    private Key lastKey;
    private Value lastValue;

    public CachedValue(Supplier<Key> getKey, Function<Key, Value> create) {
        this(getKey, create, Objects::equals, Function.identity());
    }

    public CachedValue(Supplier<Key> getKey, Function<Key, Value> create, Function<Key, Key> copy) {
        this(getKey, create, Objects::equals, copy);
    }

    public CachedValue(Supplier<Key> getKey, Function<Key, Value> create, BiPredicate<Key, Key> equivalent, Function<Key, Key> copy) {
        this.getKey = getKey;
        this.create = create;
        this.equivalent = equivalent;
        this.copy = copy;
    }

    @Override
    public Value get() {
        Key currentKey = this.getKey.get();
        if (!this.equivalent.test(currentKey, this.lastKey)) {
            this.lastKey = this.copy.apply(currentKey);
            this.lastValue = this.create.apply(currentKey);
        }
        return this.lastValue;
    }

    public void reset() {
        this.lastKey = null;
        this.lastValue = null;
    }
}

