/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util;

import blusunrize.immersiveengineering.api.utils.FastEither;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;

public class FastDataResult<T> {
    private final FastEither<T, String> valueOrError;

    private FastDataResult(FastEither<T, String> valueOrError) {
        this.valueOrError = valueOrError;
    }

    public static <T> FastDataResult<T> success(T value) {
        return new FastDataResult<T>(FastEither.left(value));
    }

    public static <T> FastDataResult<T> error(String message) {
        return new FastDataResult<T>(FastEither.right((Object)message));
    }

    public boolean isError() {
        return this.valueOrError.isRight();
    }

    public String getErrorMessage() {
        return (String)this.valueOrError.rightNonnull();
    }

    public <T2> FastDataResult<T2> propagateError() {
        Preconditions.checkState((boolean)this.isError());
        return FastDataResult.error(this.getErrorMessage());
    }

    public T get() {
        return (T)this.valueOrError.leftNonnull();
    }

    public <T2> FastDataResult<T2> flatMap(Function<T, FastDataResult<T2>> to) {
        if (this.isError()) {
            return this.propagateError();
        }
        return to.apply(this.get());
    }

    public <T2> FastDataResult<T2> map(Function<T, T2> map) {
        if (this.isError()) {
            return this.propagateError();
        }
        return FastDataResult.success(map.apply(this.get()));
    }

    @Contract(value="!null -> !null")
    public T orElse(T fallback) {
        if (this.isError()) {
            return fallback;
        }
        return this.get();
    }
}

