/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.energy;

import javax.annotation.Nonnull;
import malte0811.controlengineering.util.energy.ExtractOnlyEnergyWrapper;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.IEnergyStorage;

public class CEEnergyStorage
implements IEnergyStorage {
    private final int capacity;
    private final int maxIn;
    private final int maxOut;
    private int energyStored;

    public CEEnergyStorage(int capacity, int maxIn, int maxOut) {
        this.capacity = capacity;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
    }

    public void setEnergyStored(int energyStored) {
        this.energyStored = energyStored;
    }

    public Tag writeNBT() {
        return IntTag.m_128679_((int)this.energyStored);
    }

    public void readNBT(Tag nbt) {
        if (nbt instanceof NumericTag) {
            this.setEnergyStored(((NumericTag)nbt).m_7047_());
        } else {
            this.setEnergyStored(0);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(this.maxIn, Math.min(maxReceive, this.capacity - this.energyStored));
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(this.maxOut, Math.min(maxExtract, this.energyStored));
        if (!simulate) {
            this.energyStored -= extracted;
        }
        return extracted;
    }

    public boolean extractOrTrue(int amount) {
        if (this.energyStored < amount) {
            return true;
        }
        this.energyStored -= amount;
        return false;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxOut > 0;
    }

    public boolean canReceive() {
        return this.maxIn > 0;
    }

    @Nonnull
    public IEnergyStorage insertOnlyView() {
        return new ExtractOnlyEnergyWrapper(this);
    }
}

