/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.math;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public class MatrixUtils {
    private static final Matrix4f MIRROR = (Matrix4f)Util.m_137469_((Object)new Matrix4f(), mat -> {
        mat.m_27624_();
        mat.m_162199_(0.5f, 0.0f, 0.0f);
        mat.m_27644_(Matrix4f.m_27632_((float)-1.0f, (float)1.0f, (float)1.0f));
        mat.m_162199_(-0.5f, 0.0f, 0.0f);
    });

    public static Vec3 transform(Matrix4f transform, double x, double y, double z) {
        Vector4f vec = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        vec.m_123607_(transform);
        vec.m_123621_();
        return new Vec3((double)vec.m_123601_(), (double)vec.m_123615_(), (double)vec.m_123616_());
    }

    public static Vec3 transform(Matrix4f transform, Vec3 in) {
        return MatrixUtils.transform(transform, in.f_82479_, in.f_82480_, in.f_82481_);
    }

    public static void rotateFacing(Matrix4f mat, Direction facing, float factor) {
        if (facing == Direction.NORTH) {
            return;
        }
        switch (facing) {
            case UP: {
                mat.m_27646_(new Quaternion(factor * 1.5707964f, 0.0f, 0.0f, false));
                break;
            }
            case DOWN: {
                mat.m_27646_(new Quaternion(-factor * 1.5707964f, 0.0f, 0.0f, false));
                break;
            }
            case SOUTH: {
                mat.m_27646_(new Quaternion(0.0f, factor * (float)Math.PI, 0.0f, false));
                break;
            }
            case EAST: {
                mat.m_27646_(new Quaternion(0.0f, -factor * 1.5707964f, 0.0f, false));
                break;
            }
            case WEST: {
                mat.m_27646_(new Quaternion(0.0f, factor * 1.5707964f, 0.0f, false));
            }
        }
    }

    public static ClipContext transformRay(Matrix4f mat, Vec3 start, Vec3 end) {
        return new ClipContext(MatrixUtils.transform(mat, start), MatrixUtils.transform(mat, end), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null);
    }

    public static Matrix4f inverseFacing(Direction facing) {
        return MatrixUtils.facing(facing, -1.0f);
    }

    public static Matrix4f inverseFacing(Direction facing, boolean mirror) {
        Matrix4f result = MatrixUtils.inverseFacing(facing);
        if (mirror) {
            result.m_27644_(MIRROR);
        }
        return result;
    }

    public static Matrix4f facing(Direction facing) {
        return MatrixUtils.facing(facing, 1.0f);
    }

    private static Matrix4f facing(Direction facing, float factor) {
        Matrix4f ret = new Matrix4f();
        ret.m_27624_();
        ret.m_162199_(0.5f, 0.5f, 0.5f);
        MatrixUtils.rotateFacing(ret, facing, factor);
        ret.m_162199_(-0.5f, -0.5f, -0.5f);
        return ret;
    }
}

